<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Inventory;
use App\Models\Category;
use App\Models\Serial;
use App\Models\SubCategory;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\DB;

class InventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    // public function index($id1, $id2)
    // {
    //     $categories = Category::findOrFail($id1);
    //     $subCategories = SubCategory::findOrFail($id2);

        

    //     $subCategoriesName = $subCategories->name;

    //     $inventories = Inventory::where('category_id', $id1)->where('subCategory_id', $id2)->get();

    //     return view('inventory.index', compact('inventories', 'subCategoriesName', 'categories', 'subCategories'));
    // }
    public function index($id1, $id2)
{
    $categories = Category::findOrFail($id1);
    $subCategories = SubCategory::findOrFail($id2);

    $subCategoriesName = $subCategories->name;

    // Get sorting direction from request, default to 'asc'
    $sort = request('sort', 'asc');

    // Fetch inventories and sort by 'buy_date'
    $inventories = Inventory::where('category_id', $id1)
                            ->where('subCategory_id', $id2)
                            ->orderBy('buy_date', $sort)
                            ->get();

    return view('inventory.index', compact('inventories', 'subCategoriesName', 'categories', 'subCategories', 'id1', 'id2'));
}




    /**
     * Show the form for creating a new resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */


    public function create()
    {
        $categories = Category::all();
        return view('inventory.create', compact('categories'));
    }

    public function getSubCategories($categoryId)
    {
        $subcategories = SubCategory::where('category_id', $categoryId)->get();
        return response()->json($subcategories);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'inventory_name' => 'required|string',
            'seqNo' => 'required|max:255',
            'brand' => 'required|string',
            'purchase_date' => 'required|date',
            'price' => 'required',
            'supplier_name' => 'required|string',
            'total_quantity' => 'required|numeric',
        ]);

        $price = str_replace(',', '', $validatedData['price']);


        if ($validatedData) {
            $inventory = new Inventory();
            $inventory->name = $validatedData['inventory_name'];
            $inventory->seqNo = $request->input('seqNo');
            $inventory->brand = $validatedData['brand'];
            $inventory->buy_date = $validatedData['purchase_date'];
            $inventory->price = number_format((float)$price, 2, '.', '');
            $inventory->subCategory_id = $request->input('subcategory_id');
            $inventory->category_id = $request->input('category_id');
            $inventory->supplierName = $validatedData['supplier_name'];
            $inventory->totalQuantity = $validatedData['total_quantity'];

            $inventory->save();

            return redirect()->route('inventory.show', [
                'id1' => $inventory->id
            ])->with([
                'success' => 'Inventory added successfully.'
            ]);
        }
    }

    public function store2(Request $request)
    {
        $validatedData = $request->validate([
            'inventory_id' => 'required|exists:inventories,id',
            'serialNo' => 'required|array',
            'serialNo.*' => 'required|string',
            'tagNumber' => 'required|array',
            'tagNumber.*' => 'required|string',
            'holder' => 'required|array',
            'holder.*' => 'required|string',
            'location' => 'required|array',
            'location.*' => 'required|exists:locations,id',
        ]);

        return back()->withErrors($validatedData)->withInput();

        $inventoryId = $validatedData['inventory_id'];

        foreach ($validatedData['serialNo'] as $index => $serialNo) {
            Serial::create([
                'inventory_id' => $inventoryId,
                'serialNo' => $serialNo,
                'tagNumber' => $validatedData['tagNumber'][$index],
                'holder' => $validatedData['holder'][$index],
                'location_id' => $validatedData['location'][$index],
            ]);
        }

        $inventory = Inventory::find($inventoryId);
        $inventory->save();

        return redirect()->route('inventory.show', [$inventoryId])->with('success', 'Serial number(s) added successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id1)
    {
        // dd($id1);
        $serials = Serial::where('inventory_id', $id1)->get();
        $inventories = Inventory::with('category', 'subCategories')->findOrFail($id1);

        $inventoryName = $inventories->name;
        $subCategoryName = $inventories->subCategories->name;

        $seqNo = $inventories->seqNo;

        $serialCount = $inventories->serials->count();


        return view('inventory.show', compact('inventories', 'inventoryName', 'serials', 'subCategoryName', 'serialCount', 'id1', 'seqNo'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $inventory = Inventory::findOrFail($id);
        $inventoryName = $inventory->name;

        return view('inventory.edit', compact('inventory', 'inventoryName'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'seqNo' => 'required|max:255',
            'brand' => 'required|string|max:255',
            'supplier' => 'required|string|max:255',
            'buy_date' => 'required|date',
            'price' => 'required',
            'totalQuantity' => 'required|numeric',
        ]);
        $price = str_replace(',', '', $validatedData['price']);

        $inventory = Inventory::findOrFail($id);
        $inventory->name = $request->input('name');
        $inventory->seqNo = $request->input('seqNo');
        $inventory->brand = $request->input('brand');
        $inventory->supplierName = $request->input('supplier');
        $inventory->buy_date = $request->input('buy_date');
        $inventory->price = number_format((float)$price, 2, '.', '');
        $inventory->totalQuantity = $request->input('totalQuantity');
        $inventory->save();

        return redirect()->route('inventory.show', $id)->with('success', 'Inventory updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $inventory = Inventory::findOrFail($id);
        $inventory->delete();

        return redirect()->route('inventory.index', ['id1' => $inventory->category_id, 'id2' => $inventory->subCategory_id])
            ->with('success', 'Inventory and associated serials and images deleted successfully.');
    }

    // public function import(Request $request)
    // {
    //     $file = $request->file('file');
    //     $fileContents = file($file->getPathname());

    //     foreach ($fileContents as $line) {
    //         $data = str_getcsv($line);

    //         Product::create([
    //             'name' => $data[0],
    //             'price' => $data[1],
    //             // Add more fields as needed
    //         ]);
    //     }

    //     return redirect()->back()->with('success', 'CSV file imported successfully.');
    // }

    // export data inventory to csv - NOR 06082024
    // public function export($id)
    // {
    //     $products = Inventory::where('id', $id)->get();
    //     $serials = Serial::where('inventory_id', $id)->get();

    //     // dd($products);
    //     // dd($serial);

    //     $csvFileName = 'products.xlsx';
    //     $headers = [
    //         'Content-Type' => 'text/xlsx',
    //         'Content-Disposition' => 'attachment; filename="' . $csvFileName . '"',
    //     ];

    //     $handle = fopen('php://output', 'w');
    //     fputcsv($handle, ['Nama', 'Serial No.', 'Tag No.', 'Url']); // Add more headers as needed

    //     foreach ($products as $product) {
    //         foreach ($serials as $serial) {
    //             $url = 'http://127.0.0.1:8000/serial/info/'.$id.'/'.$serial->id;

    //             fputcsv($handle, [$product->name, $serial->serialNo, $serial->tagNumber, $url]); // Add more fields as needed
    //     }

    //     fclose($handle);

    //     return Response::make('', 200, $headers);
    // }

    public function export(Request $request, $id)
    {

        $products = Inventory::where('id', $id)->get();
        $serials = Serial::where('inventory_id', $id)->get();

        $headers[] = [
            'Nama',
            'Serial No.',
            'Tag No.',
            'Url',
        ];

        foreach ($products as $product) {
            foreach ($serials as $serial) {
                $url = URL::to('/serial/info/' . $id . '/' . $serial->id);
                $data[] = [
                    $product->name,
                    $serial->serialNo,
                    $serial->tagNumber,
                    $url,
                ];
            }
        }

        //merge header and content 
        $invent = array_merge($headers, $data);

        // wrap content into collect to export to xlsx
        return collect($invent)->downloadExcel($product->name . '.xlsx');

        // // working using inventoryExport
        // return Excel::download(new InventoryExport, 'inventPro.xlsx');

        // //working using direct call model but only 1 table
        // return Inventory::all()->downloadExcel('inventPro.xlsx');

    }

    public function showHolder()
    {
        $holderList = Serial::select('holder', DB::raw('COUNT(*) as count'))
                        ->groupBy('holder')
                        ->orderBy('holder', 'Asc')
                        ->get();

        return view('inventory.holder', compact('holderList'));
    }

    public function viewHolder($holder)
    {
        $holderList = DB::table('inventories')
                        ->select('inventories.id', 'inventories.name as aset', 'serials.tagNumber as Tag', 
                                 'serials.serialNo as serial', 'locations.name as location', 
                                 DB::raw('YEAR(serials.created_at) as year'))
                        ->join('serials', 'serials.inventory_id', '=' , 'inventories.id')
                        ->join('locations', 'locations.id', '=' , 'serials.location_id')
                        ->where(['holder' => $holder])
                        ->get();

        return view('inventory.viewHolder', compact('holderList'));
    }

    public function viewHistory($aset)
    {
        $holderList = DB::table('inventories')
                        ->select('inventories.id', 'inventories.name as aset', 'locations.name as location', DB::raw('YEAR(serials.created_at) as year'))
                        ->join('serials', 'serials.inventory_id', '=' , 'inventories.id')
                        ->join('locations', 'locations.id', '=' , 'serials.location_id')
                        ->where(['holder' => $aset])
                        ->get();

        return view('inventory.historyHolder', compact('holderList'));
    }

}
