@extends('layouts.app')

@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="index.html"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Inventory/</a></li>
                                                <li class="breadcrumb-item"><a href="#!">Add New Inventory</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Add New Inventory</h5>
                                    </div>
                                    <div class="card-body">
                                        @if ($message = Session::get('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($message = Session::get('error'))
                                            <div class="alert alert-danger" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <form method="post" action="{{ route('inventory.store') }}">
                                            @csrf
                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="inputCategory">Category</label>
                                                    <select id="inputCategory" class="form-control" name="category_id">
                                                        <option value="">Select Category</option>
                                                        @foreach ($categories as $category)
                                                            <option value="{{ $category->id }}"
                                                                {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                                                {{ $category->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-12">
                                                    <label for="inputSubCategory">Sub Category</label>
                                                    <select id="inputSubCategory" class="form-control"
                                                        name="subcategory_id">
                                                        <option value="">Select Sub Category</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputInventory">Inventory Name</label>
                                                    <input type="text" class="form-control" id="inputInventory"
                                                        name="inventory_name" value="{{ old('inventory_name') }}"
                                                        placeholder="Inventory Name">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="supName">Sequence No.</label>
                                                    <input type="text" class="form-control" id="seqNo" name="seqNo"
                                                        value="{{ old('seqNo') }}" placeholder="Insert Sequence No.">
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputBrand">Brand</label>
                                                    <input type="text" class="form-control" id="inputBrand"
                                                        name="brand" value="{{ old('brand') }}" placeholder="Brand">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="inputDate">Date of Purchase</label>
                                                    <input type="date" class="form-control" id="inputDate"
                                                        name="purchase_date" value="{{ old('purchase_date') }}"
                                                        placeholder="##/#/####">
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="inputPrice">Cost</label>
                                                    <input type="text" class="form-control" id="inputPrice"
                                                        name="price" value="{{ old('price') }}" placeholder="RM">
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="supName">Supplier Name</label>
                                                    <input type="text" class="form-control" id="supName"
                                                        name="supplier_name" value="{{ old('supplier_name') }}"
                                                        placeholder="Academy Sdn Bhd">
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="totalQuantity">Total Quantity</label>
                                                    <input type="text" class="form-control" id="totalQuantity"
                                                        name="total_quantity" value="{{ old('total_quantity') }}"
                                                        placeholder="Total Quantity">
                                                </div>
                                            </div>
                                            <hr>
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </form>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#inputCategory').on('change', function() {
                var categoryId = $(this).val();
                if (categoryId) {
                    $.ajax({
                        url: "{{ route('inventory.getSubCategories', ['categoryId' => ':categoryId']) }}"
                            .replace(':categoryId', categoryId),
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#inputSubCategory').empty();
                            $('#inputSubCategory').append(
                                '<option value="">Select Sub Category</option>');
                            $.each(data, function(key, value) {
                                $('#inputSubCategory').append('<option value="' + value
                                    .id + '">' + value.name + '</option>');
                            });
                        }
                    });
                } else {
                    $('#inputSubCategory').empty();
                    $('#inputSubCategory').append('<option value="">Select Sub Category</option>');
                }
            });

            // subcategory dropdown  old value
            var oldCategoryId = "{{ old('category_id') }}";
            if (oldCategoryId) {
                $('#inputCategory').val(oldCategoryId).change();
                var oldSubCategoryId = "{{ old('subcategory_id') }}";
                $.ajax({
                    url: "{{ route('inventory.getSubCategories', ['categoryId' => ':categoryId']) }}"
                        .replace(':categoryId', oldCategoryId),
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('#inputSubCategory').empty();
                        $('#inputSubCategory').append('<option value="">Select Sub Category</option>');
                        $.each(data, function(key, value) {
                            $('#inputSubCategory').append('<option value="' + value.id + '"' + (
                                    oldSubCategoryId == value.id ? ' selected' : '') + '>' +
                                value.name + '</option>');
                        });
                    }
                });
            }
        });
    </script>

@endsection
