@extends('layouts.app')

@section('content')
    <style>
        .box-item {
            border: 1px solid #ccc;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        .image-container {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            background-color: #f9f9f9;
        }

        .image-box {
            width: calc(20% - 10px); /* Adjust width as needed */
            height: 100px;
            border: 2px solid #ccc;
            text-align: center;
            line-height: 100px;
            position: relative;
            box-sizing: border-box;
        }

        .image-box img {
            max-width: 100%;
            max-height: 100%;
            vertical-align: middle;
        }

        .image-box label {
            display: block;
            cursor: pointer;
        }

        .highlight {
            border: 2px solid #28a745;
        }

        .back-button-container {
            position: absolute;
            top: 10px;
            left: 10px;
            z-index: 1000;
        }
        .swal2-container {
    z-index: 1051 !important; /* Higher than Bootstrap modal z-index (1050) */
}
    </style>

    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <div class="page-header">
                                <div class="page-block"></div>
                            </div>

                            <div class="center-container">
                                <div class="col-sm-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="back-button-container">
                                                <a href="{{ route('serial.show', ['id1' => $id1, 'id2' => $id2]) }}" class="btn btn-secondary back-button">Back</a>
                                            </div>
                                            <div class="row justify-content-center">
                                                <div class="col text-center">
                                                    <img class="img-fluid"
                                                        style="width: 200px; height: 100px; object-fit: cover; object-position: center;"
                                                        src="{{ asset('../assets/images/logo.png') }}" alt="InventPRO Logo">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-body task-details">
                                                @if ($message = Session::get('success'))
                                                    <div class="alert alert-success" role="alert">
                                                        {{ $message }}
                                                    </div>
                                                @endif

                                                @if ($message = Session::get('error'))
                                                    <div class="alert alert-danger" role="alert">
                                                        {{ $message }}
                                                    </div>
                                                @endif

                                                @if ($errors->any())
                                                    <div class="alert alert-danger" role="alert">
                                                        <ul>
                                                            @foreach ($errors->all() as $error)
                                                                <li>{{ $error }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                @endif

                                                <!-- Button Container -->

                                                <form action="{{ route('serial.update', ['id1' => $id1, 'id2' => $id2]) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <table class="table" style="table-layout: fixed !important;">
                                                        <tbody>
                                                            <tr>
                                                                <td><i class="fas fa-box m-r-5"></i> Serial Number:</td>
                                                                <td style="width: 25%">
                                                                    <input type="text" name="serialNo"
                                                                        value="{{ $serial->serialNo }}"
                                                                        class="form-control">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><i class="fas fa-money-check m-r-5"></i> Tag Number:
                                                                </td>
                                                                <td style="width: 25%">
                                                                    <input type="text" name="tagNumber"
                                                                        value="{{ $serial->tagNumber }}"
                                                                        class="form-control" readonly>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><i class="fas fa-box m-r-5"></i> Holder:</td>
                                                                <td style="width: 25%">
                                                                    <input type="text" name="holder"
                                                                        value="{{ $serial->holder }}" class="form-control">
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><i class="fas fa-box m-r-5"></i> Status:</td>
                                                                <td style="width: 25%">
                                                                    <div class="form-group">
                                                                        <label for="status">Status</label>
                                                                        <select name="status" id="status" class="form-control">
                                                                            <option value="">Select Status</option>
                                                                            <option value="In Use/Active" {{ $serial->status == 'In Use/Active' ? 'selected' : '' }}>In Use/Active</option>
                                                                            <option value="Damaged" {{ $serial->status == 'Damaged' ? 'selected' : '' }}>Damaged</option>
                                                                            <option value="Lost/Not Found" {{ $serial->status == 'Lost/Not Found' ? 'selected' : '' }}>Lost/Not Found</option>
                                                                            <!-- Add more options as needed -->
                                                                        </select>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><i class="fas fa-box m-r-5"></i>Location:</td>
                                                                <td style="width: 25%">
                                                                    <select name="location" class="form-control">
                                                                        <option value="">Select Location</option>
                                                                        @foreach ($locations as $location)
                                                                            <option value="{{ $location->id }}"
                                                                                {{ $serial->location_id == $location->id ? 'selected' : '' }}>
                                                                                {{ $location->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>

                                                    <div class="card-body">
                                                        <h5>Pictures:</h5>
                                                        <div class="image-container">
                                                            @php
                                                                // Count the number of existing images
                                                                $existingImagesCount = 0;
                                                                foreach (range(1, 7) as $index) {
                                                                    $imageField = 'image' . $index;
                                                                    if (!empty($serial->images->first()->$imageField)) {
                                                                        $existingImagesCount++;
                                                                    }
                                                                }
                                                    
                                                                // Calculate the remaining slots for new images
                                                                $remainingSlots = 7 - $existingImagesCount;
                                                            @endphp
                                                    
                                                            @if ($existingImagesCount == 0)
                                                                <input type="file" name="photos[]" id="photos" class="form-control-file" multiple>
                                                            @else
                                                                @foreach (range(1, 7) as $index)
                                                                    @php
                                                                        $imageField = 'image' . $index;
                                                                    @endphp
                                                                    <div class="image-box" id="imageBox{{ $index }}">
                                                                        @if (!empty($serial->images->first()->$imageField))
                                                                            <img src="{{ Storage::url($serial->images->first()->$imageField) }}"
                                                                                 onclick="openModal('{{ Storage::url($serial->images->first()->$imageField) }}', {{ $index }})"
                                                                                 alt="Selected Image">
                                                                        @else
                                                                            @if ($index > $existingImagesCount && $remainingSlots > 0)
                                                                            <label for="Image{{ $index }}">
                                                                                <span id="text{{ $index }}">Select Image</span>
                                                                                <input type="file" name="photos[]" class="form-control-file" id="Image{{ $index }}"
                                                                                       onchange="previewImage(event, 'preview{{ $index }}', 'text{{ $index }}')" style="display: none;">
                                                                                <img id="preview{{ $index }}" src="#" alt="Selected Image" style="display: none; max-width: 100%; max-height: 90%; object-fit: cover;">
                                                                            </label>
                                                                                @php
                                                                                    $remainingSlots--;
                                                                                @endphp
                                                                            @endif
                                                                        @endif
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    

                                                    <div class="text-center">
                                                        <button type="submit" class="btn btn-primary">Save Changes</button>
                                                    </div>
                                                </form>
                                            </div>

                                            <div class="modal fade" id="imageModal" tabindex="-1" role="dialog"
                                                aria-labelledby="imageModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="imageModalLabel">Image Preview
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <img id="modalImage" src="#" alt="Selected Image"
                                                                style="width: 100%;">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-dismiss="modal">Close</button>
                                                            <button type="button" class="btn btn-primary"
                                                                id="selectImage">Select Image</button>
                                                            <button type="button" class="btn btn-danger"
                                                            id="deleteImageButton">Delete</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>

let currentImageIndex;
let serialId = {{ $serial->id }}; // Ensure this is set correctly


 document.getElementById('text{{ $index }}').addEventListener('click', function() {
            document.getElementById('Image{{ $index }}').click();
        });
function openModal(src, index) {
    document.getElementById('modalImage').src = src;
    currentImageIndex = index; // Set the current index for deletion
    // dd($currentImageIndex);
    $('#imageModal').modal('show');
}

document.getElementById('deleteImageButton').addEventListener('click', function () {
    // Temporarily hide the modal
    $('#imageModal').modal('hide');
    
    // Show SweetAlert2 dialog
    Swal.fire({
        title: 'Are you sure?',
        text: "This will delete the image permanently.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            // Make an AJAX request to delete the image
            $.ajax({
                url: `/serials/${serialId}/delete-image/${currentImageIndex}`, // Ensure this route is correct
                
                type: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Deleted!', 'Your image has been deleted.', 'success').then(() => {
                            document.getElementById('imageBox' + currentImageIndex).innerHTML = ''; // Clear the image
                        });
                    } else {
                        Swal.fire('Error!', response.message || 'An error occurred while deleting the image.', 'error').then(() => {
                            $('#imageModal').modal('show');
                        });
                    }
                },
                error: function() {
                    Swal.fire('Error!', 'An error occurred while deleting the image.', 'error').then(() => {
                   
                        $('#imageModal').modal('show');
                    });
                }
            });
        } else {
            $('#imageModal').modal('show');
        }
    });
});

        

        

    
        
    </script>
@endsection
