@extends('layouts.app')

@section('content')
    <style>
        .table td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-9">
                                            <h4>Inventory Details</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            <div class="center-container">
                                <!-- card inventory info start -->
                                <div class="col-sm-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <div class="row justify-content-center">
                                                <div class="col text-center">
                                                    <img class="img-fluid"
                                                        style="width: 200px; height: 100px; object-fit: cover; object-position: center;"
                                                        src="{{ asset('../assets/images/logo.png') }}" alt="InventPRO Logo">
                                                </div>

                                                <div>
                                                    <button type="button" class="btn btn-glow btn-info"
                                                        onclick="window.location.href='{{ route('serial.edit', ['id1' => $id1, 'id2' => $id2]) }}'">Edit</button>
                                                </div>
                                                <div class="col-1.5">
                                                    <form action="{{ route('serial.destroy', ['id' => $id2]) }}"
                                                        method="POST" id="deleteForm">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" class="btn btn-danger"
                                                            onclick="confirmDelete()"><i class="feather icon-slash"></i>
                                                            Delete
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="card">
                                            <div class="card-body">
                                                <table class="table" style="table-layout: fixed;">
                                                    <tbody>
                                                        <!-- Inventory details rows -->
                                                        <tr>
                                                            <td><i class="fas fa-box m-r-5"></i> Inventory Name:</td>
                                                            <td style="width: 45%;">{{ $inventories->name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-flag"></i> Status:</td>
                                                            <td style="width: 25%;">{{ $serial->status ?? 'Unknown' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-certificate"></i> Brand:</td>
                                                            <td style="width: 25%;">{{ $inventories->brand }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-box m-r-5"></i> Date of Purchase:</td>
                                                            <td style="width: 25%;">{{ $inventories->buy_date }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-file-invoice"></i> Serial Number:</td>
                                                            <td style="width: 25%;">{{ $serial->serialNo }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-tag"></i> Tag Number:</td>
                                                            <td style="width: 25%;">{{ $serial->tagNumber }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-user-circle"></i> Holder:</td>
                                                            <td style="width: 25%;">{{ $serial->holder }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td><i class="fas fa-map-pin"></i> Location:</td>
                                                            <td style="width: 25%;">{{ $serial->location->name }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="card-body">
                                                <h5>Pictures:</h5>
                                                <div class="row">
                                                    @foreach ($serial->images as $image)
                                                        @foreach (range(1, 7) as $index)
                                                            @php
                                                                $imageField = 'image' . $index;
                                                            @endphp
                                                            @if ($image->$imageField)
                                                                <div class="col-md-3">
                                                                    <img src="{{ Storage::url($image->$imageField) }}"
                                                                        class="img-fluid mb-2"
                                                                        style="max-height: 150px; cursor: pointer;"
                                                                        onclick="showModal(this);">
                                                                </div>
                                                            @endif
                                                        @endforeach
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- card inventory info end -->

                                <!-- Back Button -->
                                <div class="row">
                                    <div class="col text-center mt-3">
                                        <button type="button" class="btn btn-secondary back-button"
                                            onclick="window.location.href='{{ route('inventory.show', ['id1' => $id1]) }}'">Back</button>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- image modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <img id="modalImage" class="img-fluid" src="" alt="Image">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for image upload -->
    <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Upload Images</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Repeat for each image box -->
                    @for ($i = 1; $i <= 7; $i++)
                        <div class="image-box" id="imageBox{{ $i }}">
                            <label for="modalImage{{ $i }}">
                                <img id="preview{{ $i }}" src="#" alt="Selected Image" style="display: none;">
                                <span id="text{{ $i }}">Select Image</span>
                            </label>
                            <input type="file" name="modalImage{{ $i }}" class="form-control-file"
                                id="modalImage{{ $i }}" onchange="previewImage(event, 'preview{{ $i }}', 'text{{ $i }}')">
                        </div>
                    @endfor
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Upload</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showModal(imgElement) {
            var modal = document.getElementById('imageModal');
            var modalImg = document.getElementById('modalImage');
            modalImg.src = imgElement.src;
            $(modal).modal('show');
        }

        function confirmDelete() {
            if (confirm('Are you sure you want to delete this record?')) {
                document.getElementById('deleteForm').submit();
            }
        }

        function previewImage(event, previewId, textId) {
            var input = event.target;
            var preview = document.getElementById(previewId);
            var text = document.getElementById(textId);

            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    text.style.display = 'none';
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
@endsection
