@extends('layouts.app')
<style>
    /* General Styles */
    body {
        font-family: 'Roboto', sans-serif;
    }

    /* Main Container */
    .pcoded-main-container {
        padding: 20px;
    }

    /* Card Styles */
    .card {
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
    }

    .card-body {
        padding: 20px;
    }

    /* Card Header */
    .card-title {
        font-size: 18px;
        font-weight: 600;
    }

    /* Financial Cards */
    .card .icon {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 40px;
        width: 40px;
        border-radius: 50%;
        font-size: 20px;
        color: #fff;
    }

    .icon-box-success {
        background-color: #28a745;
    }

    .icon-box-danger {
        background-color: #dc3545;
    }

    .icon-item {
        font-size: 20px;
    }

    /* Transaction History */
    .transaction-chart {
        width: 100%;
        height: 200px;
    }

    /* Recent Activity */
    .bg-gray-dark {
        background-color: #f8f9fa;
    }

    .preview-list {
        margin-top: 20px;
    }

    .preview-item {
        display: flex;
        align-items: center;
        padding: 10px 0;
    }

    .preview-thumbnail {
        width: 50px;
        height: 50px;
        margin-right: 15px;
    }

    .preview-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        height: 50px;
        width: 50px;
        border-radius: 50%;
        color: #fff;
    }

    .bg-primary {
        background-color: #007bff;
    }

    .bg-success {
        background-color: #28a745;
    }

    .bg-info {
        background-color: #17a2b8;
    }

    .bg-warning {
        background-color: #ffc107;
    }

    .bg-danger {
        background-color: #dc3545;
    }

    .preview-item-content {
        flex-grow: 1;
        display: flex;
        justify-content: space-between;
    }

    .text-muted {
        color: #6c757d;
    }

    /* Responsive Adjustments */
    @media (max-width: 767px) {
        .pcoded-main-container {
            padding: 10px;
        }

        .card-body {
            padding: 15px;
        }

        .card-title {
            font-size: 16px;
        }

        .transaction-chart {
            height: 150px;
        }

        .preview-item {
            flex-direction: column;
            align-items: flex-start;
        }

        .preview-thumbnail {
            margin-bottom: 10px;
        }
    }
</style>
@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="#">Category</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Financial Cards -->
                            <div class="row">
                                <div class="col-xl-6 col-sm-6 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-9">
                                                    <div class="d-flex align-items-center align-self-start">
                                                        <h3 class="mb-0">{{ number_format($totalQuantity)}} Assets</h3>
                                                        {{-- <p class="text-danger ml-2 mb-0 font-weight-medium">-2.4%</p> --}}
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="icon">
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <h6 class="text-muted font-weight-normal">{{$companyName}}</h6>
                                        </div>
                                    </div>
                                </div>
                                {{-- <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-9">
                                                    <div class="d-flex align-items-center align-self-start">
                                                        <h3 class="mb-0">{{ number_format($totalQuantity) }} Assets</h3>
                                                        <p class="text-success ml-2 mb-0 font-weight-medium">+11%</p>
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="icon">
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <h6 class="text-muted font-weight-normal">{{$companyName}}</h6>
                                        </div>
                                    </div>
                                </div> --}}
                                {{-- <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-9">
                                                    <div class="d-flex align-items-center align-self-start">
                                                        <h3 class="mb-0">{{ number_format($totalQuantity)}} Assets</h3>
                                                        <p class="text-success ml-2 mb-0 font-weight-medium">+11%</p>
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="icon">
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <h6 class="text-muted font-weight-normal">Proview Technology Sdn Bhd</h6>
                                        </div>
                                    </div>
                                </div> --}}
                                
                                
                            </div>

                            <!-- Charts -->
                            <div class="row">
                                <!-- Donut Chart -->
                                <div class="col-md-6 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h4 class="card-title mb-0">Condition</h4>
                                                {{-- <div class="dropdown mb-1">
                                                    <button class="btn btn-sm btn-secondary dropdown-toggle" type="button" id="dataDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                                        Select Data
                                                    </button>
                                                    <ul class="dropdown-menu" aria-labelledby="dataDropdown">
                                                        <li><a class="dropdown-item" href="#" id="total-btn">Total Asset Condition</a></li>
                                                        <li><a class="dropdown-item" href="#" id="proview-btn">Proview</a></li>
                                                        <li><a class="dropdown-item" href="#" id="prooffice-btn">Prooffice</a></li>
                                                    </ul>
                                                </div> --}}
                                            </div>
                                            <div id="donut-chart" class="mt-3"></div> <!-- Donut Chart container -->
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Bar Chart -->
                                {{-- <div class="col-md-6 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <h4 class="card-title">Aset Location</h4>
                                            <div id="chart"></div> <!-- Bar Chart container -->
                                        </div>
                                    </div>
                                </div> --}}
                            </div>
                            
                            <!-- Recent Activity -->
                            {{-- <div class="row">
                                <div class="col-md-12 grid-margin stretch-card">
                                    <div class="card">
                                        <div class="card-body">
                                            <h4 class="card-title">Recent Activity</h4>
                                            <div class="preview-list">
                                                <div class="preview-item border-bottom-0">
                                                    <div class="preview-thumbnail">
                                                        <div class="icon icon-box-primary">
                                                            <span class="mdi mdi-account-multiple icon-item"></span>
                                                        </div>
                                                    </div>
                                                    <div class="preview-item-content">
                                                        <h6 class="preview-subject">New User Registration</h6>
                                                        <p class="text-muted mb-0">+ 200 Users</p>
                                                    </div>
                                                </div>
                                                <div class="preview-item border-bottom-0">
                                                    <div class="preview-thumbnail">
                                                        <div class="icon icon-box-success">
                                                            <span class="mdi mdi-currency-usd icon-item"></span>
                                                        </div>
                                                    </div>
                                                    <div class="preview-item-content">
                                                        <h6 class="preview-subject">Sales Report Generated</h6>
                                                        <p class="text-muted mb-0">+ $3000</p>
                                                    </div>
                                                </div>
                                                <div class="preview-item border-bottom-0">
                                                    <div class="preview-thumbnail">
                                                        <div class="icon icon-box-danger">
                                                            <span class="mdi mdi-alert icon-item"></span>
                                                        </div>
                                                    </div>
                                                    <div class="preview-item-content">
                                                        <h6 class="preview-subject">Server Error</h6>
                                                        <p class="text-muted mb-0">+ 5 Errors</p>
                                                    </div>
                                                </div>
                                                <div class="preview-item border-bottom-0">
                                                    <div class="preview-thumbnail">
                                                        <div class="icon icon-box-warning">
                                                            <span class="mdi mdi-bell icon-item"></span>
                                                        </div>
                                                    </div>
                                                    <div class="preview-item-content">
                                                        <h6 class="preview-subject">Notifications</h6>
                                                        <p class="text-muted mb-0">+ 100 Notifications</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> --}}

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        // Donut Chart for 'Condition'
       

        document.addEventListener('DOMContentLoaded', function () {
    // Initial data
    var proviewData = [{{ $inUseProview }}, {{ $storeProview }}, {{ $damagedProview }}, {{ $lostProview }}];
    var proofficeData = [{{ $inUseProoffice }}, {{ $storeProoffice }}, {{ $damagedProoffice }}, {{ $lostProoffice }}];
    var combinedData = [{{ $inUse }}, {{ $damaged }}, {{ $lost}}];

    // Initial chart options
    var options = {
        chart: {
            type: 'donut',
        },
        series: combinedData, // Default to Proview data
        labels: ['In Use/Active', 'Damaged', 'lost/NotFound'],
        colors: ['#28a745', '#dc3545', '#000000'],
    };

    var chart = new ApexCharts(document.querySelector("#donut-chart"), options);
    chart.render();

    function closeDropdown() {
        var dropdownToggle = document.getElementById('dataDropdown');
        if (dropdownToggle) {
            var bsDropdown = new bootstrap.Dropdown(dropdownToggle);
            bsDropdown.hide(); // Hide the dropdown
        }
    }

    // Event listener for Proview dropdown item
    document.getElementById('proview-btn').addEventListener('click', function() {
        chart.updateSeries(proviewData);
    });

    // Event listener for Prooffice dropdown item
    document.getElementById('prooffice-btn').addEventListener('click', function() {
        chart.updateSeries(proofficeData);
    });
    document.getElementById('total-btn').addEventListener('click', function() {
        chart.updateSeries(combinedData);
        
    });
    document.addEventListener('click', function(event) {
        var target = event.target;
        if (!target.closest('.dropdown') && !target.matches('#dataDropdown')) {
            var dropdownMenu = document.querySelector('.dropdown-menu.show');
            if (dropdownMenu) {
                var bsDropdown = new bootstrap.Dropdown(document.getElementById('dataDropdown'));
                bsDropdown.hide();
            }
        }
    });
});


        // Bar Chart for 'Monthly Sales'
       

        var options = {
          series: [
          {
            data: [
              {
                x: 'New Delhi',
                y: 218
              },
              {
                x: 'Kolkata',
                y: 149
              },
              {
                x: 'Mumbai',
                y: 184
              },
              {
                x: 'Ahmedabad',
                y: 55
              },
              {
                x: 'Bangaluru',
                y: 84
              },
              {
                x: 'Pune',
                y: 31
              },
              {
                x: 'Chennai',
                y: 70
              },
              {
                x: 'Jaipur',
                y: 30
              },
              {
                x: 'Surat',
                y: 44
              },
              {
                x: 'Hyderabad',
                y: 68
              },
              {
                x: 'Lucknow',
                y: 28
              },
              {
                x: 'Indore',
                y: 19
              },
              {
                x: 'Kanpur',
                y: 29
              }
            ]
          }
        ],
          legend: {
          show: false
        },
        chart: {
          height: 320,
          type: 'treemap'
        },
        };

        var chart = new ApexCharts(document.querySelector("#chart"), options);
        chart.render();
    </script>
@endsection
