@extends('layouts.app')

@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Inventory</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            {{-- table category start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    {{-- <div class="card-header">
                                        <div class="row">
                                            <div class="col">
                                                <h5>Inventory</h5>
                                            </div>
                                        </div>
                                    </div> --}}

                                    <div class="card-body">

                                        @if ($message = Session::get('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($message = Session::get('error'))
                                            <div class="alert alert-danger" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <div class="dt-responsive table-responsive">
                                            <table id="dom-table" class="table table-striped table-bordered nowrap ">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">No.</th>
                                                        <th>Location</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php
                                                        $counter = 1;
                                                    @endphp
                                                    @foreach ($locations as $location)
                                                        <tr>
                                                            <td class="col-1 text-center">{{ $counter++ }}</td>
                                                            <td>{{ $location->name }}</td>
                                                            <td class="col-1 text-center "><a
                                                                    href="{{ route('location.edit', $location->id) }}"><i
                                                                        class="feather icon-edit"></i>-Edit</a></td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- table category end --}}

                            {{-- add category form start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col">
                                                <h5>Add New Location</h5>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-body">

                                        <form action="{{ route('location.store') }}" method="POST">
                                            @csrf

                                            <div class="form-row">
                                                <div class="form-group col-md-12">
                                                    <label for="inputInventory">New Location</label>
                                                    <input type="text" class="form-control" id="locationName"
                                                        name="name" placeholder="Location Name">
                                                </div>
                                            </div>
                                            <hr>
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </form>

                                    </div>
                                </div>
                            </div>
                            {{-- add location form end --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
