@extends('layouts.app-')

@section('content')

<!-- [ Main Content ] start -->
<section class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10"><?=$pageTitle?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ breadcrumb ] end -->
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="dt-responsive table-responsive">
                                            <table id="simpletable" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Email</th>
                                                        <th>Site/Organization</th>
                                                        <th>Level</th>
                                                        <th width="20%"></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                        $Sqlholder = "SELECT *,B.name as branch,C.name as org FROM pengguna A
                                                                        LEFT JOIN branch B ON A.branch_id = B.branch_id
                                                                        LEFT JOIN organization C ON A.organization_id = C.organization_id
                                                                        ORDER BY A.nama";
                                                        $resultHolder = mysqli_query($conn, $Sqlholder) or die('Query failed. ' . mysqli_error());
                                                        if (mysqli_num_rows($resultHolder) != 0)
                                                        {
                                                            while($rowHolder = mysqli_fetch_array($resultHolder))
                                                            {
                                                                $userID = $rowHolder['user_id'];

                                                                $msg1 = "'Are you sure you want to delete this user?'";
                                                                echo "<tr>";
                                                                    echo "<td>".$rowHolder['nama']."</td>";
                                                                    echo "<td>".$rowHolder['email']."</td>";
                                                                    echo "<td>".$rowHolder['branch'].$rowHolder['org']."</td>";
                                                                    if($rowHolder['level'] == 1)
                                                                    {
                                                                        echo "<td>Super Admin</td>";
                                                                    }
                                                                    else if($rowHolder['level'] == 2)
                                                                    {
                                                                        echo "<td>Organization Admin</td>";
                                                                    }
                                                                    else if($rowHolder['level'] == 3)
                                                                    {
                                                                        echo "<td>Site Admin</td>";
                                                                    }
                                                                    else if($rowHolder['level'] == 4)
                                                                    {
                                                                        echo "<td>Vendor</td>";
                                                                    }
                                                                    else 
                                                                    {
                                                                        echo "<td>Technical Support</td>";
                                                                    }
                                                                    echo "<td>";
                                                                        echo "<a href='user_profile.php?uid=$userID'><button class='btn btn-info btn-lg' >View</button></a>";
                                                                        echo "<a href='user_update.php?upd=$userID'><button class='btn btn-warning btn-lg' >Update</button></a>";
                                                                        echo '<a href="user_list.php?padam='.$userID.'" onclick="return confirm('.$msg1.')"><button class="btn btn-danger btn-lg" >Delete</button></a>';
                                                                    echo "</td>";
                                                                echo "</tr>";
                                                            }
                                                        }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- [ Main Content ] end -->

@endsection
