<?php 

namespace App\Http\Controllers;

use App\Models\Peranan;
use App\Models\Module;
use App\Models\PerananAkses;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PerananController extends Controller
{
    public function index()
    {
        $peranan = Peranan::with('akses.module')->get();
        $modules = Module::all();

        return view('peranan.index', compact('peranan', 'modules'));
    }

    public function create()
    {
        return view('peranan.add');
    }

    public function store(Request $request)
    {
        $request->validate([
            'peranan' => 'required|unique:peranans,peranan',
        ]);

        Peranan::create([
            'peranan' => $request->peranan,
        ]);

        return redirect()->route('peranan.index')->with('success', 'Peranan berjaya ditambah.');
    }

    public function edit($id)
    {
        $peranan = Peranan::findOrFail($id);
        return view('peranan.add', compact('peranan'));
    }

    public function update(Request $request, $id)
    {
        $peranan = Peranan::findOrFail($id);

        $request->validate([
            'peranan' => 'required|unique:roles,peranan,' . $peranan->id,
        ]);

        $peranan->update([
            'peranan' => $request->peranan,
        ]);

        return redirect()->route('peranan.index')->with('success', 'Peranan berjaya dikemaskini.');
    }

    public function destroy($id)
    {
        $peranan = Peranan::findOrFail($id);
        $peranan->delete();

        return redirect()->route('peranan.index')->with('success', 'Peranan berjaya dipadam.');
    }

    // public function editPermissions($id)
    // {
    //     $role = Peranan::findOrFail($id);
    //     $permissions = Module::all();
    //     $existingAccesses = PerananAkses::where('role_id', $id)->get();

    //     return view('peranan.assign-permissions', compact('role', 'permissions', 'existingAccesses'));
    // }

        // public function updatePermissions(Request $request, $id)
    // {
    //     $role = Peranan::findOrFail($id);
    //     $inputs = $request->input('permissions', []); // Each item like "5|1"

    //     $akses = collect($inputs)->map(function ($item) use ($id) {
    //         [$permissionId, $actionId] = explode('|', $item);
    //         return [
    //             'role_id' => $id,
    //             'permission_id' => $permissionId,
    //             'action_id' => $actionId,
    //         ];
    //     });

    //     DB::transaction(function () use ($id, $akses) {
    //         PerananAkses::where('role_id', $id)->delete();
    //         PerananAkses::insert($akses->toArray());
    //     });

    //     return redirect()->route('peranan.index')->with('success', 'Kebenaran berjaya dikemaskini.');
    // }

    public function editPermissions($id)
    {
        $peranan = Peranan::findOrFail($id);
        $modules = Module::all();

        $existingAccesses = PerananAkses::where('peranan_id', $id)->get();

        // Build list like: ["5|1", "5|2", "6|1"]
        $existingAccessesFormatted = $existingAccesses
            ->map(fn($a) => $a->module_id . '|' . $a->action_id)
            ->toArray();

        return view('peranan.assign-permissions', compact('peranan', 'modules', 'existingAccessesFormatted'));
    }

    public function updatePermissions(Request $request, $id)
    {
        $role = Peranan::findOrFail($id);
        $inputs = $request->input('modules', []); // Each item like "5|1"

        $akses = collect($inputs)->map(function ($item) use ($id) {
            [$moduleId, $actionId] = explode('|', $item);
            return [
                'peranan_id' => $id,
                'module_id' => $moduleId,
                'action_id' => $actionId,
            ];
        });

        DB::transaction(function () use ($id, $akses) {
            PerananAkses::where('peranan_id', $id)->delete();
            PerananAkses::insert($akses->toArray());
        });

        return redirect()->route('peranan.index')->with('success', 'Kebenaran berjaya dikemaskini.');
    }


}
