@extends('layouts.app')
<style>
    body {
        font-family: 'Roboto', sans-serif;
    }

    .pcoded-main-container {
        padding: 20px;
    }

    .card {
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        margin-bottom: 20px;
    }

    .card-body {
        padding: 20px;
    }

    .card-title {
        font-size: 18px;
        font-weight: 600;
    }

    /* Enhanced custom table styles with better spacing and appearance */
    .table-bordered-custom {
        border: 1px solid #dee2e6;
        table-layout: fixed;
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
        line-height: 1.5;
    }

    .table-bordered-custom th,
    .table-bordered-custom td {
        border: 1px solid #dee2e6;
        padding: 16px 12px;
        vertical-align: middle;
        word-wrap: break-word;
        word-break: break-word;
        overflow-wrap: break-word;
        text-align: left;
    }

    .table-bordered-custom thead th {
        background-color: #f8f9fa;
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        color: #495057;
        border-bottom: 2px solid #dee2e6;
        height: 50px;
    }

    .table-bordered-custom tbody tr {
        background-color: #ffffff;
        min-height: 60px;
    }

    .table-bordered-custom tbody tr:nth-child(even) {
        background-color: #f8f9fa;
    }

    .table-bordered-custom tbody tr:hover {
        background-color: #e9ecef;
        transition: background-color 0.2s ease;
    }

    .table-bordered-custom tbody td {
        height: 60px;
        font-size: 14px;
        color: #495057;
    }

    /* Remove nowrap for specific table cells */
    #dom-table {
        table-layout: fixed;
        width: 100%;
        border-collapse: collapse;
    }

    #dom-table th,
    #dom-table td {
        white-space: normal !important;
        word-break: break-word;
        overflow-wrap: break-word;
        padding: 8px;
        vertical-align: top;
        font-size: 14px;
        max-width: 200px;
    }

    /* Column widths */
    #dom-table th:nth-child(1),
    #dom-table td:nth-child(1) {
        width: 5%;
    }
    #dom-table th:nth-child(2),
    #dom-table td:nth-child(2) {
        width: 20%;
    }
    #dom-table th:nth-child(3),
    #dom-table td:nth-child(3) {
        width: 20%;
    }
    #dom-table th:nth-child(4),
    #dom-table td:nth-child(4) {
        width: 10%;
    }
    #dom-table th:nth-child(5),
    #dom-table td:nth-child(5) {
        width: 10%;
    }
    #dom-table th:nth-child(6),
    #dom-table td:nth-child(6) {
        width: 10%;
    }

    /* Row status colors */
    .table-success {
        background-color: #d4edda !important;
    }
    
    .table-warning {
        background-color: #fff3cd !important;
    }
    
    .table-danger {
        background-color: #f8d7da !important;
    }
</style>

@section('content')
<section class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">

                        <!-- [ breadcrumb ] start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">JKR Hulu Langat</h5>
                                        </div>
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item">
                                                <a href="{{ route('dashboard') }}"><i class="feather icon-home"></i></a>
                                            </li>
                                            <li class="breadcrumb-item">
                                                <a href="{{ route('dashboard') }}">Laporan</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ breadcrumb ] end -->
                        
                        <!-- Recent Applications Table -->
                        <div class="row">
                            <div class="col-md-12 grid-margin stretch-card">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="card-title mb-4">Status Terkini & Masa Respons</h4>
                                        <table id="dom-table" class="table table-bordered-custom">
                                            <thead>
                                                <tr>
                                                    <th>No.</th>
                                                    <th>No. Surat</th>
                                                    <th>Jenis Surat</th>
                                                    <th>Pegawai Bertugas</th>
                                                    <th>Tarikh Terima</th>
                                                    <th>Tempoh Masa</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $counter = 1 @endphp
                                                @forelse($recentApplications ?? [] as $application)
                                                    @php
                                                        $tempoh = $application->tempoh_masa ?? 0;
                                                        $rowClass = '';
                                                        if (!is_null($application->tempoh_masa)) {
                                                            if ($application->tempoh_masa <= 10) {
                                                                $rowClass = 'table-success';
                                                            } elseif ($application->tempoh_masa >= 11 && $application->tempoh_masa <= 14) {
                                                                $rowClass = 'table-warning';
                                                            } else {
                                                                $rowClass = 'table-danger';
                                                            }
                                                        }
                                                    @endphp
                                                    <tr class="{{ $rowClass }}">
                                                        <td>{{ $counter++ }}</td>
                                                        <td>{{ $application->no_siri_rujukan }}</td>
                                                        <td>{{ $application->type }}</td>
                                                        <td>{{ $application->assignedUser->name ?? 'Tiada' }}</td>
                                                        <td>{{ $application->tarikh_permohonan ? \Carbon\Carbon::parse($application->tarikh_permohonan)->format('d/m/Y') : 'N/A' }}</td>
                                                        <td>{{ $application->tempoh_masa ?? 0 }} hari</td>
                                                        <td>{{ config('optionHandler.status.' . $application->status, 'Tiada Tindakan') }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="7" class="text-center">Tiada aplikasi terkini</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection