<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
// use Spatie\Activitylog\ActivitylogOptions;
use Spatie\Activitylog\LogOptions;

class Category extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $table = 'categories';

    protected $fillable = [
        'name',
        'code',
    ];

    // Specify which attributes you want to log
    protected static $logAttributes = ['name', 'code'];

    // Customize the log name if needed
    protected static $logName = 'category';

    // Define the getActivitylogOptions method
    public function getActivitylogOptions(): LogOptions
    {
        // return LogOptions::create()
        //     ->setLogName(self::$logName)
        //     ->logAll()
        //     // ->useLogName(self::$logName)
        //     ->setDescriptionForEvent(fn(string $eventName) => "This category has been {$eventName}");
        return (new LogOptions())
        ->logAll()
        ->setDescriptionForEvent(fn(string $eventName) => "This category has been {$eventName}");

    }

    // If your table doesn't have timestamps, set this to false
    public $timestamps = false;

    // Optionally, customize the description of the log
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This model has been {$eventName}";
    }

    public function subCategories()
    {
        return $this->hasMany(SubCategory::class, 'category_id', 'id');
    }

    public function inventories()
    {
        return $this->hasMany(Inventory::class, 'category_id', 'id');
    }
}
