<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;


class Inventory extends Model
{
    use HasFactory;

    public $trkhmula, $trkhtamat, $reportType, $location;
    protected $table = 'inventories';
    protected $fillable = [
        'name',
        'buy_date',
        'brand',
        'price',
        'holder',
        'location_id',
        'category_id',
        'subCategory_id',
        'supplierName',
        'totalQuantity'
    ];

    public function location()
    {
        return $this->belongsTo(Location::class, 'location_id', 'id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function subCategories()
    {
        return $this->belongsTo(SubCategory::class, 'subCategory_id', 'id');
    }

    public function serials(): HasMany
    {
        return $this->hasMany(Serial::class)->with('images');
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($inventory) {
            $inventory->serials->each->delete();
        });
    }
}
