<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->date('buy_date');
            $table->string('brand');
            $table->string('price');
            $table->string('quantity');
            $table->string('holder')->constrained('users')->nullable();
            $table->foreignId('category_id')->constrained('categories');
            $table->foreignId('subCategory_id')->constrained('subcategories');
            $table->string('supplierName')->nullable();
            $table->integer('totalQuantity')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventories');
    }
};
