@extends('layouts.app')

@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Inventory</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            {{-- table index start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">

                                        @if ($message = Session::get('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($message = Session::get('error'))
                                            <div class="alert alert-danger" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <div class="dt-responsive table-responsive">
                                            <table id="dom-table" class="table table-striped table-bordered nowrap ">
                                                <thead>
                                                    <tr>
                                                        <th>No.</th>
                                                        <th>Category</th>
                                                        <th class="col-2 text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if ($categories->isNotEmpty())
                                                        @php $counter = 1 @endphp
                                                        @foreach ($categories as $category)
                                                            <tr>
                                                                <td class="col-1">{{ $counter++ }}</td>
                                                                <td>{{ $category->name }}</td>
                                                                <td class="col-2 text-center">
                                                                    <a href="{{ route('subCategory.index', ['id' => $category->id]) }}"
                                                                        class="btn btn-primary btn-sm">View</a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="10" class="text-center">No Data Found</td>
                                                        </tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- table index end --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
