

<?php $__env->startSection('content'); ?>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Category
                                                        Management</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            <!-- Add category form start -->
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-sm-8 mb-3">
                                                <select id="categorySelect" class="form-control">
                                                    <option value="">Select Category</option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?>

                                                            (<?php echo e($category->code); ?>)</option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col text-right">
                                                <div class="dropdown">
                                                    <button class="btn btn-primary btn-rounded dropdown-toggle"
                                                        type="button" id="dropdownMenuButton" data-toggle="dropdown"
                                                        aria-haspopup="true" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <a class="dropdown-item" href="#" data-toggle="modal"
                                                            data-target="#addCategoryModal">Add Category</a>
                                                        <a class="dropdown-item" href="#" data-toggle="modal"
                                                            data-target="#addSubCategoryModal">Add Sub-Category</a>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('category.show')); ?>">Category
                                                            List</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="card-body">
                                        <?php if($message = Session::get('success')): ?>
                                            <div class="alert alert-success" role="alert">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php endif; ?>

                                        <?php if($message = Session::get('error')): ?>
                                            <div class="alert alert-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php endif; ?>

                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($error); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>

                                        <div class="dt-responsive table-responsive">
                                            <table id="subcategoryTable" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">No.</th>
                                                        <th>Subcategory</th>
                                                        <th>Code</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!-- Subcategories will be populated here -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <!-- Add Category Modal -->
                                    <div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog"
                                        aria-labelledby="addCategoryModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="addCategoryModalLabel">Add New Category</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('category.store')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="form-group">
                                                            <label for="categoryName">New Category</label>
                                                            <input type="text" class="form-control" id="categoryName"
                                                                name="name" placeholder="Category Name" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="categoryCode">Category Code</label>
                                                            <input type="text" class="form-control" id="categoryCode"
                                                                name="code" placeholder="Category Code" required>
                                                        </div>
                                                        <button type="submit" class="btn btn-primary">Submit</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End of Add Category Modal -->

                                    <!-- Add Sub-Category Modal -->
                                    <div class="modal fade" id="addSubCategoryModal" tabindex="-1" role="dialog"
                                        aria-labelledby="addSubCategoryModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="addSubCategoryModalLabel">Add New
                                                        Sub-Category</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="<?php echo e(route('subCategory.store')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="form-group">
                                                            <label for="inputCategory">Choose Category</label>
                                                            <select id="inputCategory" class="form-control"
                                                                name="category_id" required>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($category->id); ?>">
                                                                        <?php echo e($category->name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="subCategoryName">New Sub-Category</label>
                                                            <input type="text" class="form-control"
                                                                id="subCategoryName" name="name"
                                                                placeholder="Sub-Category Name" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="subCategoryCode">Sub-Category Code</label>
                                                            <input type="text" class="form-control"
                                                                id="subCategoryCode" name="code"
                                                                placeholder="Sub-Category Code" required>
                                                        </div>
                                                        <button type="submit" class="btn btn-primary">Submit</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End of Add Sub-Category Modal -->
                                </div>
                            </div>
                            <!-- Add category form end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.getElementById('categorySelect').addEventListener('change', function() {
            var categoryId = this.value;
            if (categoryId) {
                fetch(`/category/${categoryId}/subcategories`)
                    .then(response => response.json())
                    .then(data => {
                        var tableBody = document.querySelector('#subcategoryTable tbody');
                        tableBody.innerHTML = '';
                        data.forEach((subCategory, index) => {
                            var row = `<tr>
                                            <td class="text-center">${index + 1}</td>
                                            <td>${subCategory.name}</td>
                                            <td>${subCategory.code}</td>
                                            <td class="text-center">
                                                <a href="<?php echo e(url('subCategory/edit')); ?>/${subCategory.id}">
                                                    <button class="btn btn-sm btn-primary">Edit</button>
                                                </a>
                                            </td>
                                        </tr>`;
                            tableBody.innerHTML += row;
                        });
                    });
            } else {
                var tableBody = document.querySelector('#subcategoryTable tbody');
                tableBody.innerHTML = '';
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Inventory-System\resources\views/category/create.blade.php ENDPATH**/ ?>