<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\SubCategory; // Ensure correct namespace for SubCategory
use Illuminate\Http\Request;

class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $categories = Category::findOrFail($id);
        $subCategories = SubCategory::where('category_id', $id)->with('category')->get();

        return view('subCategory.index', compact('subCategories', 'categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::all();
        $subCategories = SubCategory::all();

        return view('subCategory.create', compact('subCategories', 'categories'));
    }


    public function getSubCategories($categoryId)
    {
        $subcategories = SubCategory::where('category_id', $categoryId)->get();
        return response()->json($subcategories);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'category_id' => 'required|integer',
            'name' => 'required|string',
            'code' => 'required|string'
        ]);

        $subCategory = new SubCategory();
        $subCategory->name = $request->input('name');
        $subCategory->code = $request->input('code');
        $subCategory->category_id = $request->input('category_id');
        $subCategory->save();

        return redirect()->route('category.create')->with('success', 'Sub-Category added successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $subCategory = SubCategory::findOrFail($id); // Use the correct model
        $categories = Category::all();

        return view('subCategory.edit', compact('subCategory', 'categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $subCategory = SubCategory::findOrFail($id); // Use the correct model
        $subCategory->update($request->all());

        return redirect()->route('category.create')->with('success', 'Sub-Category updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
