<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class SetTenantSession
{
    /**
     * Handle an incoming request.
     * 
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (session()->has('db_conn')) {
            $db_tenant = session('db_conn');
            config(['database.default' => $db_tenant]);
            DB::purge($db_tenant);  // purge any previous connection
            DB::reconnect($db_tenant);  // reconnect new connection

        }

        return $next($request);
    }
}
