<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;


class Holder extends Model
{
    use HasFactory;
    use LogsActivity;

    protected $table = 'holder'; 

    protected $fillable = [
        'name',
        'code',
    ];

    // Specify which attributes you want to log
    protected static $logAttributes = ['name', 'code'];

    // Customize the log name if needed
    protected static $logName = 'category';

    // Define the getActivitylogOptions method
    public function getActivitylogOptions(): LogOptions
    {
        return (new LogOptions())
        ->logAll()
        ->setDescriptionForEvent(fn(string $eventName) => "This category has been {$eventName}");
    }

    // Optionally, customize the description of the log
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This model has been {$eventName}";
    }
    

}
