<?php

// app/Http/Middleware/SetDatabaseConnection.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\DB;

class SetDatabaseConnection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (session()->has('db_conn')) {
            $connectionName = session('db_conn');
            config(['database.default' => $connectionName]);
            DB::reconnect($connectionName);
        }

        return $next($request);
    }
}
