<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB; 
use Illuminate\Support\Facades\Session; // Assuming you use Session 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class TenantAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // 1. Tenant Connection Setup
        $dbConn = Session::get('db_conn'); // Fetch from session
        // dd($dbConn);
        if ($dbConn) {
            config(['database.default' => $dbConn]);
            // dd(config(['database.default' => $dbConn]));

            DB::reconnect($dbConn);
            Log::debug('dbConn:', ['dbConn' => $dbConn]);
        }
        
        //Authentication Check
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        //Proceed if Authenticated
        return $next($request);
    }
}
