
let itemCount = 0;

function addItem() {
    if (itemCount < 5) {
        itemCount++;
        const container = document.getElementById('items-container');
        const itemDiv = document.createElement('div');
        itemDiv.className = 'item border p-3 mb-3';
        itemDiv.id = `item-${itemCount}`;
        itemDiv.innerHTML = `
            <h6>Item ${itemCount}</h6>
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label for="serialNo${itemCount}">No</label>
                    <input type="text" name="serialNo[]" class="form-control"
                        id="serialNo${itemCount}" placeholder="Serial Number"
                        value="{{ old('serialNo') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="serialNo${itemCount}">Serial Number</label>
                    <input type="text" name="serialNo[]" class="form-control"
                        id="serialNo${itemCount}" placeholder="Serial Number"
                        value="{{ old('serialNo') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="tagNumber${itemCount}">Tag Number</label>
                    <input type="text" name="tagNumber[]" class="form-control"
                        id="tagNumber${itemCount}" placeholder="Tag Number"
                        value="{{ old('tagNumber') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="yearsOfPurchase${itemCount}">Years of Purchase</label>
                    <input type="text" name="yearsOfPurchase[]" class="form-control"
                        id="yearsOfPurchase${itemCount}" placeholder="Years of Purchase"
                        value="{{ old('yearsOfPurchase') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="monthOfPurchase${itemCount}">Month Of Purchase</label>
                    <input type="text" name="monthOfPurchase[]" class="form-control"
                        id="monthOfPurchase${itemCount}" placeholder="Month Of Purchase"
                        value="{{ old('monthOfPurchase') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="totalQuantity${itemCount}">Total Quantity</label>
                    <input type="text" name="totalQuantity[]" class="form-control"
                        id="totalQuantity${itemCount}" placeholder="Total Quantity"
                        value="{{ old('totalQuantity') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="runningNumber${itemCount}">Running Number</label>
                    <input type="text" name="runningNumber[]" class="form-control"
                        id="runningNumber${itemCount}" placeholder="Running Number"
                        value="{{ old('runningNumber') }}">
                </div>
                <div class="form-group col-md-6">
                    <label for="image${itemCount}">Image</label>
                    <input type="file" name="image[]" class="form-control-file"
                        id="image${itemCount}">
                </div>
                <div class="form-group col-md-6">
                    <label for="location${itemCount}">Location</label>
                    <input type="text" name="location[]" class="form-control"
                        id="location${itemCount}" placeholder="Location"
                        value="{{ old('location') }}">
                </div>
            </div>
        `;
        container.appendChild(itemDiv);
    } else {
        Swal.fire({
            title: 'Oops!',
            text: 'You can only add up to 5 items.',
            icon: 'warning',
            confirmButtonText: 'OK'
        });
    }
}

function removeItem() {
    if (itemCount > 0) {
        const container = document.getElementById('items-container');
        const itemDiv = document.getElementById(`item-${itemCount}`);
        container.removeChild(itemDiv);
        itemCount--;
    } else {
        Swal.fire({
            title: 'Oops!',
            text: 'There are no items to remove.',
            icon: 'warning',
            confirmButtonText: 'OK'
        });
    }
}
