@extends('layouts.app')

@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item">
                                                    <a href="{{ route('home') }}">
                                                        <i class="feather icon-home"></i>
                                                    </a>
                                                </li>
                                                <li class="breadcrumb-item"><a href="">Inventory</a></li>
                                                <li class="breadcrumb-item"><a
                                                        href="">{{ $inventory->category->name }}</a></li>
                                                <li class="breadcrumb-item"><a href="">{{ $inventoryName }}</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            {{-- card inventory info start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="col-xl-12 col-lg-12 task-detail-right">
                                        <div class="card">
                                            <div class="card-body task-details">

                                                @if ($message = Session::get('success'))
                                                    <div class="alert alert-success" role="alert">
                                                        {{ $message }}
                                                    </div>
                                                @endif

                                                @if ($message = Session::get('error'))
                                                    <div class="alert alert-danger" role="alert">
                                                        {{ $message }}
                                                    </div>
                                                @endif

                                                @if ($errors->any())
                                                    <div class="alert alert-danger" role="alert">
                                                        <ul>
                                                            @foreach ($errors->all() as $error)
                                                                <li>{{ $error }}</li>
                                                            @endforeach
                                                        </ul>
                                                    </div>
                                                @endif


                                                <form action="{{ route('inventory.update', ['id' => $inventory->id]) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('PUT')

                                                    <div class="form-group">
                                                        <label for="price">Inventory Name:</label>
                                                        <input type="text" id="name" name="name"
                                                            class="form-control" value="{{ $inventory->name }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="price">Sequence No:</label>
                                                        <input type="text" id="seqNo" name="seqNo"
                                                            class="form-control" value="{{ $inventory->seqNo }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="price">Brand:</label>
                                                        <input type="text" id="brand" name="brand"
                                                            class="form-control" value="{{ $inventory->brand }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="price">Supplier Name:</label>
                                                        <input type="text" id="supplier" name="supplier"
                                                            class="form-control" value="{{ $inventory->supplierName }}"
                                                            required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="buy_date">Date of Purchase:</label>
                                                        <input type="date" id="buy_date" name="buy_date"
                                                            class="form-control" value="{{ $inventory->buy_date }}"
                                                            required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="price">Price per Unit:</label>
                                                        <input type="text" id="price" name="price"
                                                            class="form-control" value="{{ $inventory->price }}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="price">Total Quantity:</label>
                                                        <input type="text" id="totalQuantity" name="totalQuantity"
                                                            class="form-control" value="{{ $inventory->totalQuantity }}">
                                                    </div>

                                                    <button type="submit" class="btn btn-primary">Update Inventory</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- card inventory info end --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
