

<?php $__env->startSection('content'); ?>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="index.html"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inventory/</a></li>
                                                <li class="breadcrumb-item"><a href="#!">Generate Report</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Please select the necessary filters</h5>
                                    </div>
                                    <div class="card-body">
                                        <?php if($message = Session::get('success')): ?>
                                            <div class="alert alert-success" role="alert">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php endif; ?>

                                        <?php if($message = Session::get('error')): ?>
                                            <div class="alert alert-danger" role="alert">
                                                <?php echo e($message); ?>

                                            </div>
                                        <?php endif; ?>

                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($error); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>

                                        <!-- <form> -->
                                        <form action="<?php echo e(route('report.laporan')); ?>" method="POST">

                                            <?php echo csrf_field(); ?>
                                            <div class="form-row">
                                                <div class="col-sm-6">
                                                    <label for="date_start">Tarikh Mula</label>
                                                    <div class="form-group">
                                                        <div class="form-line">
                                                            <input type="date" class="form-control" id="trkhmula"
                                                                name="trkhmula" value="<?php echo e(old('trkhmula')); ?>"
                                                                placeholder="##/#/####">                                                        
                                                            </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <label for="date_start">Tarikh Tamat</label>
                                                    <div class="form-group">
                                                        <div class="form-line">
                                                            <input type="date" class="form-control" id="inputDate"
                                                                name="trkhtamat" value="<?php echo e(old('trkhtamat')); ?>"
                                                                placeholder="##/#/####">                                                        
                                                            </div>
                                                    </div>
                                                </div> 
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="status">Status</label>
                                                    <select name="status" class="form-control"
                                                        id="status">
                                                        <option value="">Select Status</option>
                                                        <option value="In Use/Active">In Use/Active</option>
                                                        <option value="Damaged">Damaged</option>
                                                        <option value="Lost/Not Found">Lost/Not Found</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-6">
                                                    <label for="location">Location</label>
                                                    <select name="location" class="form-control">
                                                        <option value="">Select Location</option>
                                                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($location->id); ?>">
                                                                <?php echo e($location->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>                                            
                                            </div>
                                            <div class="form-row">
                                                <div class="form-group col-md-6">
                                                    <label for="reportType">Report</label>
                                                    <select name="reportType" class="form-control">
                                                        <option value="">Select Report</option>
                                                        <?php $__currentLoopData = $repType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="text-right form-group col-md-12">
                                                <button type="submit" class="btn btn-primary">Generate</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#inputCategory').on('change', function() {
                var categoryId = $(this).val();
                if (categoryId) {
                    $.ajax({
                        url: "<?php echo e(route('inventory.getSubCategories', ['categoryId' => ':categoryId'])); ?>"
                            .replace(':categoryId', categoryId),
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $('#inputSubCategory').empty();
                            $('#inputSubCategory').append(
                                '<option value="">Select Sub Category</option>');
                            $.each(data, function(key, value) {
                                $('#inputSubCategory').append('<option value="' + value
                                    .id + '">' + value.name + '</option>');
                            });
                        }
                    });
                } else {
                    $('#inputSubCategory').empty();
                    $('#inputSubCategory').append('<option value="">Select Sub Category</option>');
                }
            });

            // subcategory dropdown  old value
            var oldCategoryId = "<?php echo e(old('category_id')); ?>";
            if (oldCategoryId) {
                $('#inputCategory').val(oldCategoryId).change();
                var oldSubCategoryId = "<?php echo e(old('subcategory_id')); ?>";
                $.ajax({
                    url: "<?php echo e(route('inventory.getSubCategories', ['categoryId' => ':categoryId'])); ?>"
                        .replace(':categoryId', oldCategoryId),
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('#inputSubCategory').empty();
                        $('#inputSubCategory').append('<option value="">Select Sub Category</option>');
                        $.each(data, function(key, value) {
                            $('#inputSubCategory').append('<option value="' + value.id + '"' + (
                                    oldSubCategoryId == value.id ? ' selected' : '') + '>' +
                                value.name + '</option>');
                        });
                    }
                });
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Inventory-System\resources\views/report/index.blade.php ENDPATH**/ ?>