<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\KategoriSurat;

class KategoriSuratController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // Load surat permohonan with progress count
        $katSurat = KategoriSurat::all();

        return view('parameter.kategori-surat.index', compact('katSurat'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('parameter.kategori-surat.index');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'kategori' => 'required|string|max:255',
        ]);

        KategoriSurat::create($validated);

        return redirect()->route('katSurat.index')->with('Berjaya', 'Kategori berjaya didaftarkan.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $katSurat = KategoriSurat::all();
        $kategoriSurat = KategoriSurat::findOrFail($id);

        return view('parameter.kategori-surat.index', compact('katSurat', 'kategoriSurat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // Step 1: Validate input
        $validated = $request->validate([
            'kategori' => 'required|string|max:255',
        ]);

        // Step 2: Find and update the model
        $kategoriSurat = KategoriSurat::findOrFail($id);
        $kategoriSurat->update($validated);

        // Step 3: Redirect back to index with success message
        return redirect()->route('katSurat.index')->with('Berjaya', 'Kategori berjaya dikemaskini.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $suratPermohonan->delete(); // Delete the record
        return redirect()->route('suratPermohonan.index')->with('Berjaya', 'Projek berjaya dipadam.');
    }

}
