<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User; // Import the User model
use App\Models\SuratPermohonan; // Import the SuratPermohonan model
use App\Models\PermohonanProjek; // Import the PermohonanProjek model
use App\Models\Aduan; // Import the PermohonanProjek model
use App\Models\Milestone; // Import the Milestone model
use App\Models\Progress;
use Illuminate\Support\Facades\Storage; // Import Storage facade

class KelulusanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // Fetch records where status is not equal to 1
        $suratPermohonan = SuratPermohonan::where('status', '=', 1)
            ->get()
            ->map(function ($item) {
                $item->type = 'Surat Permohonan'; // Add type for identification
                return $item;
            });
    
        $permohonanProjek = Aduan::where('status', '=', 1)
            ->get()
            ->map(function ($item) {
                $item->type = 'Aduan'; // Add type for identification
                return $item;
            });
    
        // Combine both collections
        $records = $suratPermohonan->merge($permohonanProjek);
    
        // Pass the combined records to the view
        return view('kelulusan.index', compact('records'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // Find the record in SuratPermohonan or PermohonanProjek
        $record = SuratPermohonan::find($id) ?? PermohonanProjek::find($id);
        $users = User::all(); // or filter by role if needed

        if ($record) {
            return view('kelulusan.show', compact('record', 'users'));
        }

        return redirect()->route('kelulusan.index')->with('error', 'Rekod tidak dijumpai.');    
    }

    public function countKelulusan($suratPermohonanId)
    {
        $count = DB::table('progress')
            ->where('surat_permohonan_id', $suratPermohonanId)
            ->count();
            
        return $count;
    }

    public function getProgressCount($suratPermohonanId)
    {
        return Progress::where('surat_permohonan_id', $suratPermohonanId)->count();
    }

    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'assign_to' => 'required|exists:users,id',
            'ulasan' => 'required|string|max:1000', // Validate ulasan
        ]);

        // Find the record in SuratPermohonan or PermohonanProjek
        $record = \App\Models\SuratPermohonan::find($id) ?? \App\Models\Aduan::find($id);

        if ($record) {
            $record->update([
                'assign_to' => $request->assign_to,
                'status' => '2',
                'ulasan' => $request->ulasan, // Assuming 'ulasan' column exists in the database
            ]);

            return redirect()->route('kelulusan.index')->with('success', 'Status berjaya dikemaskini.');
        }

        return redirect()->route('kelulusan.index')->with('error', 'Rekod tidak dijumpai.');
    }

}
