<?php
namespace App\Http\Controllers;

use App\Models\SuratPermohonan;
use App\Models\PermohonanProjek;
use App\Models\Progress;
use App\Models\Aduan;
use App\Models\User;

use Carbon\Carbon;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;

class LaporanController extends Controller
{
    public function index(Request $request)
    {
        // Get recent applications with response time for the table
        // $recentApplications = $this->getRecentApplicationsWithResponseTime($request);
        $recentApplications = $this->getRecentApplicationsWithResponseTime($request, 10);
        
        // Pass the data to the laporan index view
        return view('laporan.index', compact('recentApplications'));
    }

    // private function getRecentApplicationsWithResponseTime($limit = 10)
    // {
    //     $surat = SuratPermohonan::with(['latestProgress', 'assignedUser']) // adjust 'assignedUser' if relationship exists
    //         ->get()
    //         ->map(function ($item) {
    //             return (object)[
    //                 'type' => 'SuratPermohonan',
    //                 'id' => $item->id,
    //                 'no_siri_rujukan' => $item->no_siri_rujukan,
    //                 'tarikh_permohonan' => $item->tarikh_permohonan,
    //                 'status' => $item->status,
    //                 'assigned_user_name' => optional($item->assignedUser)->name,
    //                 'tempoh_masa' => $item->latestProgress 
    //                     ? $item->latestProgress->created_at->diffInDays($item->tarikh_terima_jkrhl)
    //                     : now()->diffInDays($item->tarikh_terima_jkrhl),
    //                 'created_at' => $item->created_at,
    //             ];
    //         });

    //     $aduan = Aduan::with(['latestProgress', 'assignedUser']) // adjust 'assignedUser' if exists
    //         ->get()
    //         ->map(function ($item) {
    //             return (object)[
    //                 'type' => 'Aduan',
    //                 'id' => $item->id,
    //                 'no_siri_rujukan' => $item->no_siri_rujukan,
    //                 'tarikh_permohonan' => $item->tarikh_permohonan,
    //                 'status' => $item->status,
    //                 'assigned_user_name' => optional($item->assignedUser)->name,
    //                 'tempoh_masa' => $item->latestProgress 
    //                     ? $item->latestProgress->created_at->diffInDays($item->tarikh_terima_jkrhl)
    //                     : now()->diffInDays($item->tarikh_terima_jkrhl),
    //                 'created_at' => $item->created_at,
    //             ];
    //         });

    //     return $surat->merge($aduan)
    //                 ->sortByDesc('created_at')
    //                 ->take($limit)
    //                 ->values(); // reset keys
    // }

    private function getRecentApplicationsWithResponseTime(Request $request, $perPage = 10)
    {
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');

        $suratQuery = SuratPermohonan::with(['latestProgress', 'assignedUser']);
        $aduanQuery = Aduan::with(['latestProgress', 'assignedUser']);

        if ($startDate && $endDate) {
            $suratQuery->whereBetween('tarikh_permohonan', [$startDate, $endDate]);
            $aduanQuery->whereBetween('tarikh_permohonan', [$startDate, $endDate]);
        }

        $surat = $suratQuery->get()->map(function ($item) {
            return (object)[
                'type' => 'SuratPermohonan',
                'id' => $item->id,
                'no_siri_rujukan' => $item->no_siri_rujukan,
                'tarikh_permohonan' => $item->tarikh_permohonan,
                'status' => $item->status,
                'assignedUser' => $item->assignedUser,
                'tempoh_masa' => $item->latestProgress 
                    ? $item->latestProgress->created_at->diffInDays($item->tarikh_terima_jkrhl)
                    : now()->diffInDays($item->tarikh_terima_jkrhl),
                'created_at' => $item->created_at,
            ];
        });

        $aduan = $aduanQuery->get()->map(function ($item) {
            return (object)[
                'type' => 'Aduan',
                'id' => $item->id,
                'no_siri_rujukan' => $item->no_siri_rujukan,
                'tarikh_permohonan' => $item->tarikh_permohonan,
                'status' => $item->status,
                'assignedUser' => $item->assignedUser,
                'tempoh_masa' => $item->latestProgress 
                    ? $item->latestProgress->created_at->diffInDays($item->tarikh_terima_jkrhl)
                    : now()->diffInDays($item->tarikh_terima_jkrhl),
                'created_at' => $item->created_at,
            ];
        });

        $merged = $surat->merge($aduan)->sortByDesc('created_at')->values();

        // If no date filters, limit to latest $limit only
        // if (!$startDate || !$endDate) {
        //     $merged = $merged->take($limit);
        // }
        // return $merged;

         // Manual pagination
        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        $collection = collect($merged);
        $paginated = new LengthAwarePaginator(
            $collection->forPage($currentPage, $perPage),
            $collection->count(),
            $perPage,
            $currentPage,
            ['path' => request()->url(), 'query' => request()->query()]
        );

        return $paginated;
    }

   

    
}