<?php
namespace App\Http\Controllers;

use App\Models\SuratPermohonan;
use App\Models\Progress;
use App\Models\User; // Import the User model 
use App\Models\KategoriSurat;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class SuratPermohonanController extends Controller
{
    public function index()
    {
        $user = auth()->user()->load('peranan.akses.module');

        // Load surat permohonan with progress count
        // $model = SuratPermohonan::withCount('progresses')->get();
        $model = SuratPermohonan::all();
        return view('surat-permohonan.index', compact('model', 'user'));
    }
    
    public function create()
    {
        $katSurat = KategoriSurat::all();

        return view('surat-permohonan.create', compact('katSurat'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'tajuk' => 'required|string',
            'penerangan' => 'required|string',
            'pemohon' => 'required|string|max:255',
            'syarikat' => 'required|string|max:255',
            'tarikh_permohonan' => 'required|date',
            'tarikh_terima_jkrhl' => 'required|date',
            'tarikh_terima_bahagian' => 'required|date',
            'no_siri_rujukan' => 'required|string',
            'kategori' => 'required|integer',
            'attachment' => 'required|file|mimes:pdf,jpg,png|max:2048',
        ]);

        // First, create the record without the attachment
        $surat = SuratPermohonan::create(array_merge($validated, ['attachment' => null]));

        // Define a unique folder for this surat inside surat-permohonan/
        $folderName = 'surat-permohonan/surat-' . $surat->id;

        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $filename = $file->getClientOriginalName();

            // Store in subfolder
            // $path = $file->storeAs($folderName, $filename, 'public');

            $fileContents = file_get_contents($file->getPathname());
            $path = $folderName . '/' . $filename;

            Storage::disk('public')->put($path, $fileContents);

            // Update the attachment path in the record
            $surat->update(['attachment' => $path]);
        }
        

        return redirect()->route('suratPermohonan.index')->with('Berjaya', 'Projek berjaya didaftarkan.');
    }
    // public function store(Request $request)
    // {
    //     // Validate input
    //     $validated = $request->validate([
    //         'tajuk' => 'required|string|max:255',
    //         'penerangan' => 'required|string',
    //         'pemohon' => 'required|string|max:255',
    //         'syarikat' => 'required|string|max:255',
    //         'tarikh_permohonan' => 'required|date',
    //         'attachment' => 'required|file|mimes:pdf,jpg,png|max:2048',
    //     ]);

    //     // Handle attachment upload BEFORE creating the record
    //     $filename = null;
    //     $tempPath = null;

    //     if ($request->hasFile('attachment')) {
    //         $file = $request->file('attachment');

    //         if (!($file instanceof UploadedFile) || !$file->isValid()) {
    //             return back()->with('error', 'Fail yang dimuat naik tidak sah.');
    //         }

    //         // Sanitize and create unique filename
    //         $filename = time() . '_' . preg_replace('/[^a-zA-Z0-9_\.-]/', '_', $file->getClientOriginalName());

    //         // Temporarily store the file in a temp folder
    //         $tempPath = Storage::disk('public')->putFileAs('surat-permohonan/temp', $file, $filename);

    //         if (!$tempPath) {
    //             return back()->with('error', 'Gagal menyimpan fail buat sementara.');
    //         }
    //     }

    //     // Create DB record with null attachment
    //     $surat = SuratPermohonan::create(array_merge($validated, ['attachment' => null]));

    //     // Move file to its final folder and update DB
    //     if ($tempPath && $filename) {
    //         $finalFolder = 'surat-permohonan/surat-' . $surat->id;
    //         $finalPath = $finalFolder . '/' . $filename;

    //         // Move the file to its final location
    //         Storage::disk('public')->makeDirectory($finalFolder);
    //         Storage::disk('public')->move($tempPath, $finalPath);

    //         // Update the attachment path in the record
    //         $surat->update(['attachment' => $finalPath]);
    //     }

    //     return redirect()->route('suratPermohonan.index')->with('Berjaya', 'Projek berjaya didaftarkan.');
    // }

    /**
     * Display the specified resource.
     */
    public function show(SuratPermohonan $suratPermohonan)
    {
        // Count progress records for this surat permohonan
        $progressCount = Progress::where('surat_id', $suratPermohonan->id)->count();
        $users = User::all(); // or filter by role if needed
        // dd($suratPermohonan->progresses);


        return view('surat-permohonan.show', compact('suratPermohonan','users', 'progressCount'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SuratPermohonan $suratPermohonan)
    {
        $katSurat = KategoriSurat::all();

        return view('surat-permohonan.create', compact('suratPermohonan', 'katSurat')); // Return to edit view
    }

    public function update(Request $request, SuratPermohonan $suratPermohonan)
    {
        // dd($request->kategori);
        $validated = $request->validate([
            'tajuk' => 'required|string',
            'penerangan' => 'required|string',
            'pemohon' => 'required|string|max:255',
            'syarikat' => 'required|string|max:255',
            'tarikh_permohonan' => 'required|date',
            'tarikh_terima_jkrhl' => 'required|date',
            'tarikh_terima_bahagian' => 'required|date',
            'no_siri_rujukan' => 'required|string',
            'kategori' => 'required|integer',
            'attachment' => 'nullable|file|mimes:pdf,jpg,png|max:2048',
        ]);

        if ($request->hasFile('attachment')) {
            $file = $request->file('attachment');
            $filename = time() . '_' . $file->getClientOriginalName();

            // Define the subfolder path
            $folderName = 'surat-permohonan/surat-' . $suratPermohonan->id;

            // Ensure the directory exists (optional, Laravel usually does this automatically)
            Storage::disk('public')->makeDirectory($folderName);

            // Delete old attachment if it exists
            if ($suratPermohonan->attachment && Storage::disk('public')->exists($suratPermohonan->attachment)) {
                Storage::disk('public')->delete($suratPermohonan->attachment);
            }

            // Store the new attachment in the folder
            // $validated['attachment'] = $file->storeAs($folderName, $filename, 'public');
            $fileContents = file_get_contents($file->getPathname());
            $path = $folderName . '/' . $filename;

            Storage::disk('public')->put($path, $fileContents);
            
            $validated['attachment'] = $path;

        }

        $suratPermohonan->update($validated);

        return redirect()->route('suratPermohonan.index')->with('Berjaya', 'Projek berjaya dikemaskini.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SuratPermohonan $suratPermohonan)
    {
        $suratPermohonan->delete(); // Delete the record
        return redirect()->route('suratPermohonan.index')->with('Berjaya', 'Projek berjaya dipadam.');
    }

    public function storeProgress(Request $request, $id)
    {
        $validated = $request->validate([
            'progress_note' => 'required|string',
            'progress_attachment' => 'nullable|file|mimes:pdf,jpg,png|max:2048',
            'status' => 'nullable|integer'
        ]);

        // Get the surat permohonan record
        $suratPermohonan = SuratPermohonan::findOrFail($id);

        if ($request->hasFile('progress_attachment')) {
            $file = $request->file('progress_attachment');
            $filename = now()->format('Ymd_His') . '_' . $file->getClientOriginalName();

            // Define folder based on surat id (same logic as store method)
            $folder = 'surat-permohonan/surat-' . $suratPermohonan->id . '/progress';

            // Store the file in the specific surat folder
            // $path = $file->storeAs($folder, $filename, 'public');
            // $validated['progress_attachment'] = $path;
            $fileContents = file_get_contents($file->getPathname());
            $path = $folder . '/' . $filename;

            Storage::disk('public')->put($path, $fileContents);

            // Update the attachment path in the record
            $validated['progress_attachment'] = $path;
        }
        // dd($validated['attachment']);

        // $validated['surat_id'] = $suratPermohonan->id;
        // Progress::create($validated);
        $suratPermohonan->progresses()->create($validated); //using morph relationship - nur 8/7/2025

        // Update status in surat_permohonan table (if status is present)
        if (!is_null($validated['status'])) {
            $suratPermohonan->update(['status' => $validated['status']]);
        }

        return redirect()->route('suratPermohonan.show', $suratPermohonan->id)
            ->with('Berjaya', 'Status surat berjaya ditambah.');
    }

    // public function getProgressCount($id)
    // {
    //     $count = Progress::where('surat_id', $id)->count();
    //     return response()->json(['count' => $count]);
    // }

    public function updatePegawai(Request $request, $id)
    {
        $suratPermohonan = SuratPermohonan::findOrFail($id);

        $validated = $request->validate([
            'assign_to' => 'required|exists:users,id',
        ]);

        // Update the assigned user for the surat permohonan
        $suratPermohonan->update($validated);

        return redirect()->route('suratPermohonan.show', $suratPermohonan->id)->with('Berjaya', 'Pegawai bertugas berjaya dikemaskini.');
    }

}