<?php

namespace App\Http\Controllers;

use App\Models\Location;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $locations = Location::all();
        // dd($locations);
        // return view('location.index', compact('locations'));
        // $locations = Location::all();
        // $locations = Location::all();
        return response()->json($locations);
    }

    public function getLocations()
    {
        $locations = Location::all();
        return response()->json($locations);
    }

    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $locations = Location::all();
        // dd($locations);
        return view('location.create', compact('locations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // validate request data
        $validatedData = $request->validate([
            'name' => 'required|string',

        ]);

        // create inventory
        $locations = new Location();
        $locations->name = $request->input('name');


        // dd($locations->locations_id);
        $locations->save();

        return redirect()->route('location.create')->with('success', 'Location added successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $locations = Location::findOrFail($id);
        return view('location.edit', compact('locations'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $locations = Location::findOrFail($id);
        $locations->update($request->all());

        return redirect()->route('location.create')->with('success', 'Location updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
