<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;

use App\Models\Category;
use App\Models\SubCategory;
use App\Models\Inventory;
use App\Models\Location;
use App\Models\Serial;
use Barryvdh\DomPDF\Facade\Pdf;

class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $report = Inventory::get()->first();
        // $serial = Serial::get()->first();
        // $locId = Location::get()->first();
        $locations = Location::all();

        // $trkhmula = $report->trkhmula;
        // $trkhtamat = $report->trkhtamat;
        // $status = $report->status;
        // dd($locId->id);

        $repType = [
            1 => 'Laporan Berdasarkan Lokasi',
            2 => 'Laporan Berdasarkan Status',
            3 => 'Report Based On Item Details',
        ];

        // dd($repType);

        return view('report.index')
        // return view('report.index', ['trkhmula' => $trkhmula, 'trkhtamat' => $trkhtamat,'status' => $status, 'locId' => $locId])
        ->with([
            // 'trkhmula' => $report->trkhmula,
            // 'trkhtamat' => $serial->trkhtamat,
            // 'status' => $serial->status,
            'locations' => $locations,
            'repType' => $repType
        ]);
    }

    public function laporan(Request $request)
    {
        // dd($request);
        $trkhmula = $request->trkhmula.' 00:00:00';
        $trkhtamat = $request->trkhtamat.' 23:59:59';
        $status = $request->status;
        $location = $request->location;
        $repType = $request->reportType;

        if($repType == 1){
            // dd('test1');
            $asets = DB::table('inventories')
                    ->select('inventories.id', 'inventories.name as Asset', 'serials.serialNo as Serial', 'locations.name as Location', 
                            DB::raw('DATE_FORMAT(date(serials.created_at), "%d-%m-%Y") as Date'))
                    ->join('serials', 'serials.inventory_id', '=' , 'inventories.id')
                    ->join('locations', 'locations.id', '=' , 'serials.location_id')
                    ->where('serials.created_at', '>=' , "$trkhmula")
                    ->where('serials.created_at', '<=' , "$trkhtamat")
                    ->where('serials.status', '=' , $status)
                    ->where('locations.id', '=' , $location)
                    ->orderBy('inventories.name')
                    ->get();
        
            //start for csv        
            $header[] = [
                'No.',
                'Asset',
                'Serial No.',
                'Location',
                'Date'
            ];

            $i = 1;
            foreach ($asets as $aset) {
                $data[] = [
                    $i++,
                    $aset->Asset,
                    $aset->Location,
                    $aset->Serial,
                    $aset->Date,
                ];
            }

            //merge header and content 
            $invent = array_merge($header, $data);
            // wrap content into collect to export to xlsx
            // return collect($invent)->downloadExcel('Location.xlsx');
            //end for csv

            // dd($invent);

            // Load the view or create HTML content from the array
            $pdf = PDF::loadView('report.location', ['asets' => $asets]);

            // Stream the PDF to the browser
            return $pdf->stream('sample.pdf');

            
        }
        if($repType == 3){
            // Query to get data with additional fields: supplierName, brand, and holder
            $asets = DB::table('inventories')
                ->select(
                    'inventories.id', 
                    'inventories.name as Asset', 
                    'serials.serialNo as Serial', 
                    'locations.name as Location', 
                    'inventories.supplierName as Supplier', 
                    'inventories.brand as Brand', 
                    'serials.holder as Holder', 
                    DB::raw('DATE_FORMAT(date(serials.created_at), "%d-%m-%Y") as Date')
                )
                ->join('serials', 'serials.inventory_id', '=' , 'inventories.id')
                ->join('locations', 'locations.id', '=' , 'serials.location_id')
                ->where('serials.created_at', '>=' , "$trkhmula")
                ->where('serials.created_at', '<=' , "$trkhtamat")
                ->where('serials.status', '=' , $status)
                ->where('locations.id', '=' , $location)
                ->orderBy('inventories.name')
                ->get();
        
            // Start for CSV        
            $header[] = [
                'No.',
                'Asset',
                'Serial No.',
                'Location',
                'Supplier',
                'Brand',
                'Holder',
                'Date'
            ];
        
            $i = 1;
            $data = [];
            foreach ($asets as $aset) {
                $data[] = [
                    $i++,
                    $aset->Asset,
                    $aset->Serial,
                    $aset->Location,
                    $aset->Supplier,
                    $aset->Brand,
                    $aset->Holder,
                    $aset->Date,
                ];
            }
        
            // Merge header and content 
            $invent = array_merge($header, $data);
            
            // Wrap content into collect to export to xlsx
            // return collect($invent)->downloadExcel('Location_with_details.xlsx');
        
            // Load the view or create HTML content from the array
            $pdf = PDF::loadView('report.reportCondition', ['asets' => $asets]);
        
            // Stream the PDF to the browser
            return $pdf->stream('asset_with_details.pdf');
        }
        

    }

}