<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ValidDomainRule implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        // split the username by the '@' symbol
        $parts = explode('@', $value);

        // check if the username has the correct format
        if (count($parts) !== 2) {
            return false;
        }

        // Check if the domain part is 'proffice' or 'proview'
        $domain = $parts[1];
        $allowedDomains = ['prooffice', 'proview'];
        return in_array($domain, $allowedDomains);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The username must be in the format xxx@proffice or xxx@proview.';
    }
}
