@extends('layouts.app')

@section('content')
    <style>
        .box-item {
            border: 1px solid #ccc;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 15px;
        }
    </style>

    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="#!">Inventory/</a></li>
                                                <li class="breadcrumb-item"><a href="#!">Add New Serial</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5>Add New Serial</h5>
                                    </div>
                                    <div class="card-body">
                                        @if ($message = Session::get('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($message = Session::get('error'))
                                            <div class="alert alert-danger" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <form action="{{ route('serial.store') }}" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="inventory_id"
                                                value="{{ old('inventory_id', $inventory->id) }}">
                                            <div id="items-container">
                                                {{-- Debugging --}}
                                                @php
                                                    $oldSerials = old('serialNo', []);
                                                    $oldHolders = old('holder', []);
                                                    $oldLocations = old('location', []);
                                                    $oldStatuses = old('status', []);
                                                @endphp

                                                {{-- Ensure loopCount runs as expected --}}
                                                @for ($i = 0; $i < $loopCount; $i++)
                                                    <div class="box-item" id="item-{{ $i + 1 }}">
                                                        <h6>Item {{ $i + 1 }}</h6>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label for="serialNo{{ $i + 1 }}">Serial
                                                                    Number</label>
                                                                <input type="text" name="serialNo[]" class="form-control"
                                                                    id="serialNo{{ $i + 1 }}"
                                                                    value="{{ old('serialNo.' . $i) }}"
                                                                    placeholder="Serial Number">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="tagNumber{{ $i + 1 }}">Tag Number</label>
                                                                <input type="text" name="tagNumber[]"
                                                                    class="form-control" id="tagNumber{{ $i + 1 }}"
                                                                    value="{{ old('tagNumber.' . $i, $tagNumber . ($i + 1) . '/' . $totalQuantity) }}"
                                                                    placeholder="Tag Number">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="holder{{ $i + 1 }}">Holder</label>
                                                                <input type="text" name="holder[]" class="form-control"
                                                                    id="holder{{ $i + 1 }}"
                                                                    value="{{ old('holder.' . $i) }}" placeholder="Holder">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="location{{ $i + 1 }}">Location</label>
                                                                <select name="location[]" class="form-control"
                                                                    id="location{{ $i + 1 }}">
                                                                    <option value="">Select Location</option>
                                                                    @foreach ($locations as $location)
                                                                        <option value="{{ $location->id }}"
                                                                            {{ old('location.' . $i) == $location->id ? 'selected' : '' }}>
                                                                            {{ $location->name }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="status{{ $i + 1 }}">Status</label>
                                                                <select name="status[]" class="form-control"
                                                                    id="status{{ $i + 1 }}">
                                                                    <option value="">Select Status</option>
                                                                    <option value="In Use/Active"
                                                                        {{ old('status.' . $i) == 'In Use/Active' ? 'selected' : '' }}>
                                                                        In Use/Active
                                                                    </option>
                                                                   
                                                                    <option value="Damaged"
                                                                        {{ old('status.' . $i) == 'Damaged' ? 'selected' : '' }}>
                                                                        Damaged
                                                                    </option>
                                                                    <option value="Lost/Not Found"
                                                                        {{ old('status.' . $i) == 'Lost/Not Found' ? 'selected' : '' }}>
                                                                        Lost/Not Found
                                                                    </option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endfor
                                            </div>
                                            <hr>
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
