<!DOCTYPE html>
<html lang="en">

<head>
    <title>Inventory Management</title>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description"
        content="Elite Able Bootstrap admin template made using Bootstrap 4 and it has huge amount of ready made feature, UI components, pages which completely fulfills any dashboard needs." />
    <meta name="keywords"
        content="admin templates, bootstrap admin templates, bootstrap 4, dashboard, dashboard templets, sass admin templets, html admin templates, responsive, bootstrap admin templates free download,premium bootstrap admin templates, Elite Able, Elite Able bootstrap admin template">
    <meta name="author" content="Phoenixcoded" />

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Favicon icon -->
    <link rel="icon" href="{{ asset('assets/images/favicon.ico') }}" type="image/x-icon">
    <!-- fontawesome icon -->
    <link rel="stylesheet" href="{{ asset('assets/fonts/fontawesome/css/fontawesome-all.min.css') }}">
    <!-- animation css -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/animation/css/animate.min.css') }}">

    <!-- data tables css -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/data-tables/css/datatables.min.css') }}">

    <!-- vendor css -->
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">

    <style>
        .center-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: calc(100vh - 100px);
            /* Adjust based on header height */
        }
    </style>
</head>

<body>
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-9">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ breadcrumb ] end -->

                        <div class="center-container">
                            <!-- card inventory info start -->
                            <div class="col-sm-9">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row justify-content-center">
                                            <div class="col text-center">
                                                <img class="img-fluid"
                                                    style="width: 200px; height: 100px; object-fit: cover; object-position: center;"
                                                    src="{{ asset('../assets/images/logo.png') }}" alt="InventPRO Logo">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card">
                                        <div class="card-body task-details">
                                            <table class="table" style="table-layout: fixed !important;">
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <i class="fas fa-box m-r-5"></i> Inventory Name: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventoryName }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <i class="fas fa-money-check m-r-5"></i> Brand: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->brand }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <i class="fas fa-box m-r-5"></i> Date of Purchase: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->buy_date }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <i class="fas fa-box m-r-5"></i>Serial Number: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;">
                                                        </td>
                                                        <td style="width: 25%">{{ $serial->serialNo }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <i class="fas fa-box m-r-5"></i> Tag Number: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;">
                                                        </td>
                                                        <td style="width: 25%">{{ $serial->tagNumber }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <div class="col text-center">
                                                <button type="button" class="btn btn-glow btn-info"
                                                    onclick="window.location.href=''">Edit</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- card inventory info end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
