<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\UserControlController;
use App\Http\Controllers\SerialController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\NavigationController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AuditLogController;

// Routes available before login
Route::get('/', function () {
    return view('auth.login');
});

// Authentication Routes with Tenant Middleware
Auth::routes();

Route::post('/login', [LoginController::class, 'login'])->name('login1')->middleware('dbConnCheck');
Route::get('/logout', [LoginController::class, 'logout'])->name('logout1');

// Route groups for authenticated users with dynamic database middleware
Route::middleware(['dynamic_db'])->group(function () {

    Route::get('/home', [HomeController::class, 'index'])->name('home')->middleware('dbConnCheck');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::group(['prefix' => 'inventory', 'as' => 'inventory.'], function () {
        Route::get('/{id1}/{id2}', [InventoryController::class, 'index'])->name('index');
        Route::get('create', [InventoryController::class, 'create'])->name('create');
        Route::post('/store', [InventoryController::class, 'store'])->name('store');
        Route::get('all/show/{id1}', [InventoryController::class, 'show'])->name('show');
        Route::get('item/edit/{id}', [InventoryController::class, 'edit'])->name('edit');
        Route::put('update/{id}', [InventoryController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [InventoryController::class, 'destroy'])->name('destroy');
        Route::get('/search', [InventoryController::class, 'search1'])->name('search1');
        Route::get('subcategories/{category_id}', [InventoryController::class, 'getSubcategories'])->name('getSubcategories');
        Route::get('inventory/get-subcategories/{categoryId}', [InventoryController::class, 'getSubCategories'])->name('getSubCategories');
        Route::get('all/export/{id}', [InventoryController::class, 'export'])->name('export');
        Route::get('/showHolder', [InventoryController::class, 'showHolder'])->name('showHolder');
        Route::get('all/viewHolder/{holder}', [InventoryController::class, 'viewHolder'])->name('viewHolder');
    });

    Route::group(['prefix' => 'serial', 'as' => 'serial.'], function () {
        Route::get('create/{id}/', [SerialController::class, 'create'])->name('create');
        Route::get('info/{id1}/{id2}', [SerialController::class, 'show'])->name('show');
        Route::get('edit/{id1}/{id2}', [SerialController::class, 'edit'])->name('edit');
        Route::put('update/{id1}/{id2}', [SerialController::class, 'update'])->name('update');
        Route::post('store', [SerialController::class, 'store'])->name('store');
        Route::put('{id1}/updateImage/{id2}/{imageIndex}', [SerialController::class, 'updateImage'])->name('updateImage');
        Route::post('{id1}/deleteImage/{imageIndex}', [SerialController::class, 'deleteImage'])->name('deleteImage');
        Route::delete('destroy/{id}', [SerialController::class, 'destroy'])->name('destroy');
        Route::get('generate/tagnumber/{id}', [SerialController::class, 'generateTagNumber'])->name('generate');
        Route::delete('delete-images/{id1}/{id2}', [SerialController::class, 'deleteImages'])->name('deleteImages');
    });

    Route::group(['prefix' => 'category', 'as' => 'category.'], function () {
        Route::get('/', [CategoryController::class, 'index'])->name('index');
        Route::get('/create', [CategoryController::class, 'create'])->name('create');
        Route::post('/store', [CategoryController::class, 'store'])->name('store');
        Route::get('/show', [CategoryController::class, 'show'])->name('show');
        Route::get('/edit/{id}', [CategoryController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [CategoryController::class, 'update'])->name('update');
        Route::delete('/destroy', [CategoryController::class, 'destroy'])->name('destroy');
        Route::get('/{id}/subcategories', [CategoryController::class, 'getSubCategories'])->name('subcategories');
    });

    Route::group(['prefix' => 'subCategory', 'as' => 'subCategory.'], function () {
        Route::get('/{id}', [SubCategoryController::class, 'index'])->name('index');
        Route::get('subCategory/create', [SubCategoryController::class, 'create'])->name('create');
        Route::post('store', [SubCategoryController::class, 'store'])->name('store');
        Route::get('/show', [SubCategoryController::class, 'show'])->name('show');
        Route::get('/edit/{id}', [SubCategoryController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [SubCategoryController::class, 'update'])->name('update');
        Route::delete('/destroy', [SubCategoryController::class, 'destroy'])->name('destroy');
    });

    Route::group(['prefix' => 'location', 'as' => 'location.'], function () {
        Route::get('/{id}', [LocationController::class, 'index'])->name('index');
        Route::get('location/create', [LocationController::class, 'create'])->name('create');
        Route::post('store', [LocationController::class, 'store'])->name('store');
        Route::get('/show', [LocationController::class, 'show'])->name('show');
        Route::get('/edit/{id}', [LocationController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [LocationController::class, 'update'])->name('update');
        Route::delete('/destroy', [LocationController::class, 'destroy'])->name('destroy');
    });

    Route::group(['prefix' => 'report', 'as' => 'report.'], function () {
        // Route::get('/report', [ReportController::class, 'index'])->name('index');
        Route::get('/index', [ReportController::class, 'index'])->name('index');
        Route::post('/laporan', [ReportController::class, 'laporan'])->name('laporan');
    });

    Route::group(['prefix' => 'user', 'as' => 'user.'], function () {
        Route::get('/index', [UserController::class, 'index'])->name('index');
        Route::get('/edit/{id}', [UserController::class, 'edit'])->name('edit');
        Route::put('/update/{id}', [UserController::class, 'update'])->name('update');
    });

    Route::group(['prefix' => 'auditLog', 'as' => 'auditLog.'], function () {
        Route::get('/index', [AuditLogController::class, 'index'])->name('index');
        // Route::get('/edit/{id}', [AuditLogController::class, 'edit'])->name('edit');
        // Route::put('/update/{id}', [AuditLogController::class, 'update'])->name('update');
    });

    
});

