

<?php $__env->startSection('content'); ?>
    <style>
        table {
            table-layout: fixed;
            width: 100%;
        }

        table th,
        table td {
            white-space: normal;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .table-responsive {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .table thead th {
            vertical-align: middle;
        }

        .table th,
        .table td {
            padding: 0.75rem;
            word-wrap: break-word;
        }
    </style>

    <?php
    ?>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="index.html"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inventory</a></li>
                                                <li class="breadcrumb-item"><a href="#!"><?php echo e($subCategoriesName); ?></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center">
                                            <div class="col-md-6 col-12">
                                                <h5><?php echo e($subCategoriesName); ?></h5>
                                            </div>
                                            <div class="col-md-4 col-12 mt-2 mt-md-0">
                                                <input type="text" id="searchInput" class="form-control"
                                                    placeholder="Search inventory...">
                                            </div>
                                            <div class="col-md-2 col-12 mt-2 mt-md-0">
                                                <a class="btn btn-primary btn-sm btn-rounded float-right"
                                                    href="<?php echo e(route('inventory.create', ['id1' => $categories->id, 'id2' => $subCategories->id])); ?>">
                                                    Add Inventory
                                                </a>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between mb-3">
                                            <form method="GET" action="<?php echo e(route('inventory.index', ['id1' => $id1, 'id2' => $id2])); ?>">
                                                <div class="form-group">
                                                    <label for="sort">Sort By Date:</label>
                                                    <select name="sort" id="sort" class="form-control" onchange="this.form.submit()">
                                                        <option value="asc" <?php echo e(request('sort') === 'asc' ? 'selected' : ''); ?>>Oldest to Newest</option>
                                                        <option value="desc" <?php echo e(request('sort') === 'desc' ? 'selected' : ''); ?>>Newest to Oldest</option>
                                                    </select>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="table-responsive">
                                            <table id="dom-table" class="table table-striped table-bordered text-center">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 5%;">No.</th>
                                                        <th style="width: 30%;">Name</th>
                                                        <th style="width: 15%;">Date of Purchase</th>
                                                        <th style="width: 15%;">Brand</th>
                                                        <th style="width: 10%;">Cost</th>
                                                        <th style="width: 15%;">Total Quantity</th>
                                                        <th style="width: 10%;">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="inventoryTable">
                                                    <?php $counter = 1 ?>
                                                    <?php if(!$inventories->isEmpty()): ?>
                                                        <?php $__currentLoopData = $inventories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inventory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="text-center"><?php echo e($counter++); ?></td>
                                                                <td><?php echo e($inventory->name); ?></td>
                                                                <td><?php echo e($inventory->buy_date); ?></td>
                                                                <td><?php echo e($inventory->brand); ?></td>
                                                                <td>RM <?php echo e(number_format($inventory->price, 2, '.', ',')); ?></td>
                                                                <td><?php echo e($inventory->totalQuantity); ?></td>
                                                                <td>
                                                                    <a href="<?php echo e(route('inventory.show', ['id1' => $inventory->id])); ?>"
                                                                        class="btn btn-primary btn-sm d-flex justify-content-center">Info</a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center">No Data Found</td>
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.getElementById('searchInput').addEventListener('keyup', function() {
            var input = this.value.toLowerCase();
            var rows = document.querySelectorAll('#inventoryTable tr');
            rows.forEach(function(row) {
                var cells = row.querySelectorAll('td');
                var match = false;
                cells.forEach(function(cell) {
                    if (cell.textContent.toLowerCase().includes(input)) {
                        match = true;
                    }
                });
                if (match) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Inventory-System\resources\views/inventory/index.blade.php ENDPATH**/ ?>